-- SQL Clr Clean Address installation
--
-- Version 1.8 - 2013-10-24 - Change starting db size to 4bm for SQL 2012
-- Version 1.7 - 2011-12-01 - Change name, add logic to overall install
-- Version 1.6 - 2011-08-09 - Add command line parameters
-- Version 1.5 - 2011-06-22 - Remove case sensitivity
-- Version 1.4 - 2011-05-26 - Add system event logging
-- Version 1.3 - 2011-04-29 - Initial Release
-- Version 1.2 - 2011-04-27 - dcn - No schema, many other changes
-- Version 1.1 - 2011-02-26 - dcn - Change db path to deploy directory
-- Version 1.0 - 2010-12-19 - dcn
--
-- Use InstallSQLCLR.bat in this directory, customize the following
--
-- -v SQLDBPATH = C:\Clean_Address_SQLCLR\Data\ -- $(SQLDBPATH)
-- -v SQLCLRBIN = C:\CLEAN_Address_SQLCLR\bin\ --$(SQLCLRBIN)
-- -v CLNADRHOST = http://localhost:8097/CLNVerify - $(CLNADRHOST)
-- -v PSUSER = "sa" - so permissions can be set if not sa
--   Notes:
--   - Create Clean_Addresss database
--   - Load 2 - SQL CLR Assemblies, target .net version is 3.5
--   - Create the Verify procedure based on the assemblies
--   - Create other stored procedures, tables and scalar functions
--   - Initialize Cln_Settings and Cln_Lookups
--   - cln_ajax_cache is used for temporary processing and should not retain any data
--   - Cln_Log is only used for debugging and not currently enabled in the release
--   - Location of the database files and SQL CLR assemblies are assumed to be C:\Clean_Address_SQLCLR but can be changed
--   - The entire database may be dropped and this script run again but you will lose any custom settings
--   - You can change the default settings in this file so that Cln_Settings contains the defaults / custom settings you want.
--   - You can change settings programatically: exec Set_Setting '','VerboseSuggestList','1'
--   - Default value of service can be found / changed by searching for LocalServiceURL =  $(CLNADRHOST)
--   - Has been tested on SQL 2005, SQL 2008 and SQL 2008 R2, SQL 2012
--
set Nocount on
--
-- Installation parameters
--
Declare @SQLDatabasePath nvarchar(500)
Declare @SQLDBFileName nvarchar(100)
Declare @SQLLogFileName nvarchar(100)

Set @SQLDatabasePath = '$(SQLDBPATH)'
Set @SQLDBFileName = @SQLDatabasePath + 'CLEAN_AddressBin.mdf'
Set @SQLLogFileName = @SQLDatabasePath + 'CLEAN_AddressBIN_log.ldf'
--
Declare @SQL nvarchar(2000)

Set @SQL = 'CREATE DATABASE [CLEAN_Address] ON  PRIMARY '
set @SQL = @SQL + '( NAME = ''CLEAN_Address'', FILENAME = ''' + @SQLDBFileName + ''', SIZE = 5120KB , FILEGROWTH = 1024KB ) '
set @SQL = @SQL + ' Log ON ( NAME = ''CLEAN_Address_log'', FILENAME = ''' + @SQLLogFileName + ''', SIZE = 1024KB , FILEGROWTH = 10%)'
--
Exec(@SQL)

go

sp_configure 'show advanced options', 1;
GO
RECONFIGURE;
GO
sp_configure 'clr enabled', 1;
GO
RECONFIGURE;
GO
--
-- Set database options, mostly default except compatibility level, we are shooting for sql 2005 compatiblitiy.
--  -- Note for SQL 2014 minimum compatibility is 100
EXEC dbo.sp_dbcmptlevel @dbname=N'CLEAN_Address', @new_cmptlevel=100
--EXEC dbo.sp_dbcmptlevel @dbname=N'CLEAN_Address', @new_cmptlevel=90
-- For SQL 2014 minimum is 100 = SQL 2008
-- EXEC dbo.sp_dbcmptlevel @dbname=N'CLEAN_Address', @new_cmptlevel=100
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
	EXEC [CLEAN_Address].[dbo].[sp_fulltext_database] @action = 'disable'
end
GO
ALTER DATABASE [CLEAN_Address] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [CLEAN_Address] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [CLEAN_Address] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [CLEAN_Address] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [CLEAN_Address] SET ARITHABORT OFF 
GO
ALTER DATABASE [CLEAN_Address] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [CLEAN_Address] SET AUTO_CREATE_STATISTICS ON 
GO
ALTER DATABASE [CLEAN_Address] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [CLEAN_Address] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [CLEAN_Address] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [CLEAN_Address] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [CLEAN_Address] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [CLEAN_Address] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [CLEAN_Address] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [CLEAN_Address] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [CLEAN_Address] SET  DISABLE_BROKER 
GO
ALTER DATABASE [CLEAN_Address] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [CLEAN_Address] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [CLEAN_Address] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [CLEAN_Address] SET  READ_WRITE 
GO
ALTER DATABASE [CLEAN_Address] SET RECOVERY SIMPLE 
GO
ALTER DATABASE [CLEAN_Address] SET  MULTI_USER 
GO
ALTER DATABASE [CLEAN_Address] SET PAGE_VERIFY CHECKSUM  
GO
USE [CLEAN_Address]
GO
IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'PRIMARY') ALTER DATABASE [CLEAN_Address] MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

ALTER DATABASE CLEAN_Address SET TRUSTWORTHY on
go

	--
	-- Clean_Address schema - Clean out previous settings. drops settings table too...
	--	
  if exists (Select [Name] from sys.sysobjects Where [name] = 'InitCap')
		drop function InitCap

	if exists (select [Name] from sys.sysobjects Where [name] = 'Get_Setting')
		drop function Get_Setting	
		
	if exists (select [Name] from sys.sysobjects Where [name] = 'Set_Setting')
		drop procedure Set_Setting	

	if exists (select [Name] from sys.procedures Where [name] = 'Verify_Address_AJAX')
		drop procedure Verify_Address_AJAX	
		
	if exists (select [Name] from sys.procedures Where [name] = 'Verify_Address_GENERIC')
		drop procedure Verify_Address_AJAX			

	if exists (select [Name] from sys.sysobjects Where [name] = 'Cln_Log')
		drop table Cln_Log		

	if exists (select [Name] from sys.sysobjects Where [name] = 'Cln_Settings')
		drop table Cln_Settings
				
	if exists (select [Name] from sys.procedures Where [name] = 'Verify')
		drop procedure verify	
		
	if exists (select [Name] from sys.procedures Where [name] = 'TestOut')
		drop procedure TestOut	

Go
--
-- Register the CLR dll's.
--
if exists (Select [Name] from sys.assemblies Where [Name] = 'CLEAN_Address_XML')
	Drop Assembly CLEAN_Address_XML with no dependents;

go

if exists (Select [Name] from sys.assemblies Where [Name] = 'CLEAN_Address_CLR')
	Drop Assembly CLEAN_Address_CLR with no dependents;

go

CREATE ASSEMBLY CLEAN_Address_CLR FROM '$(SQLCLRBIN)CleanAddressCLR.dll' with permission_set = EXTERNAL_ACCESS
go
CREATE ASSEMBLY CLEAN_Address_XML FROM '$(SQLCLRBIN)CleanAddressCLR.XmlSerializers.dll' with permission_set = SAFE
go

--
-- Create the settings table
--
CREATE TABLE Cln_Settings(
	[Group] [nvarchar](50) not NULL,
	[Code] [nvarchar](50) NOT null,
	[Value] [nvarchar](50) NULL,
 CONSTRAINT [PK_Cln_Settings] PRIMARY KEY CLUSTERED 
(
	[Code] ASC,
	[Group] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[Cln_Log](
	[LogID] [int] IDENTITY(1,1) NOT NULL,
	[LogDateTime] [datetime] NULL,
	[LogMessage] [nvarchar](4000) NULL,
 CONSTRAINT [PK_Cln_Log] PRIMARY KEY CLUSTERED 
(
	[LogID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Cln_Log] ADD  CONSTRAINT [DF_Cln_Log_LogDateTime]  DEFAULT (getdate()) FOR [LogDateTime]
GO

--
-- Initialize Settings
--
insert into Cln_Settings values ('','LocalServiceURL','$(CLNADRHOST)') -- Change this if your service is not local!!
insert into Cln_Settings values ('','VerifyAddress', '1')
insert into Cln_Settings values ('','GeoCodeAddress', '1')
insert into Cln_Settings values ('','CheckTelephone', '0')
insert into Cln_Settings values ('','ParseName', '0')
insert into Cln_Settings values ('','ParseEmail', '0')
insert into Cln_Settings values ('','DNSCheckEmail', '0')
insert into Cln_Settings values ('','UseGenericAddressLines', '1')
insert into Cln_Settings values ('','GenericAddressLines', '3')
insert into Cln_Settings values ('','FullNameInAddress', '0')
insert into Cln_Settings values ('','CompanyNameInAddress', '0')
insert into Cln_Settings values ('','OutputAddressWithCompanyNameAttention', '0')
insert into Cln_Settings values ('','CountryReturnType', '')
insert into Cln_Settings values ('','PreferredLanguage', '') -- String
insert into Cln_Settings values ('','ErrorSuggestCount', '20')
insert into Cln_Settings values ('','VerboseSuggestList', '0')
insert into Cln_Settings values ('','IncludeSuggestHeader', '0')
insert into Cln_Settings values ('','MaxCityLength', '30')
insert into Cln_Settings values ('','MaxProvinceLength', '0')
insert into Cln_Settings values ('','MaxAddressLineLength', '60')
insert into Cln_Settings values ('','UseUSPSPreferredCity', '0')
insert into Cln_Settings values ('','ExpandStreetSuffix', '1')
insert into Cln_Settings values ('','ExpandSingleDirectional', '1')
insert into Cln_Settings values ('','ExpandDoubleDirectional', '0')
insert into Cln_Settings values ('','ExpandUnitType', '0')
insert into Cln_Settings values ('','SuiteLineBeforeStreet', '0')
insert into Cln_Settings values ('','AppendSuiteToStreet', '0')
insert into Cln_Settings values ('','PrefixSuiteForCanada', '0')
insert into Cln_Settings values ('','AlwaysStandardize', '0')
insert into Cln_Settings values ('','AlwaysUpperCase', '0')
insert into Cln_Settings values ('','BasicAddressSearch', '0')
insert into Cln_Settings values ('','PhoneNumberOutputFormat', '') -- String

go
--
-- InitCap function
--
CREATE FUNCTION [dbo].[InitCap] ( @InputString varchar(4000) ) 
RETURNS VARCHAR(4000)
AS
BEGIN

DECLARE @Index          INT
DECLARE @Char           CHAR(1)
DECLARE @PrevChar       CHAR(1)
DECLARE @OutputString   VARCHAR(255)

SET @OutputString = LOWER(@InputString)
SET @Index = 1

WHILE @Index <= LEN(@InputString)
BEGIN
    SET @Char     = SUBSTRING(@InputString, @Index, 1)
    SET @PrevChar = CASE WHEN @Index = 1 THEN ' '
                         ELSE SUBSTRING(@InputString, @Index - 1, 1)
                    END

    IF @PrevChar IN (' ', ';', ':', '!', '?', ',', '.', '_', '-', '/', '&', '''', '(')
    BEGIN
        IF @PrevChar != '''' OR UPPER(@Char) != 'S'
            SET @OutputString = STUFF(@OutputString, @Index, 1, UPPER(@Char))
    END

    SET @Index = @Index + 1
END

RETURN @OutputString

END
GO
--
-- Create Settings procedures
--
-- Version 0.1 - 2010-11-06 - dcn
CREATE FUNCTION Get_Setting
(
  @Group nvarchar(50),
  @Code nvarchar(50)
)
RETURNS nvarchar(50)
AS
BEGIN
	Declare @Value nvarchar(50)
	
	Select @Value = Value 
	From Cln_Settings
	Where [Group] = @Group and Code = @Code
	--
		
	return @Value

END

GO

--Version 1.0 - 2011-04-29 - dcn
CREATE FUNCTION dbo.Translate 
 (
 @Input AS nvarchar(1000),
 @Find AS nvarchar(100),
 @Replace AS nvarchar(100)
 )
 RETURNS nvarchar(1000)
AS
BEGIN
 
 DECLARE @i AS int
 
 SELECT @i = 1
 
 WHILE @i <= LEN(@Find) BEGIN
  
  SELECT @Input = REPLACE(@Input, SUBSTRING(@Find, @i, 1), SUBSTRING(@Replace, @i, 1))
  SELECT @i = @i + 1
 
 END
 RETURN @Input
END

GO
--
-- Create Settings procedures
--
-- Version 1.0 - 2011-05-11 - dcn - Add nocount on
-- Version 0.1 - 2010-11-06 - dcn
Create Procedure Set_Setting
  @Group nvarchar(50),
  @Code nvarchar(50),
  @Value nvarchar(50)
as
	Set NoCount on
	
	Declare @Ret int
	Declare @ValidValue int
	Set @ValidValue = 0
	--
	-- Validate value...
	-- Possibilities are bool int or string
	--
	--If @Code = 'PreferredLanguageType' and @Value not in ('DEFAULT','ENGLISH','NATIVE')
	--	Set @ValidValue = 0
	--else if @Code = 'CountryReturnType' and @Value not in ('ISO_2','ISO_3','ISO_NUMBER','ABBREVIATION','NAME')
	--	Set @ValidValue = 0
	
	If @ValidValue = 0
	  begin
		Update Cln_Settings
		Set Value = @Value
		Where [Group] = @Group
		and Code = @Code
		
		Set @Ret = @@ROWCOUNT
		--
		-- If now rows affected, insert
		--
		if @Ret = 0
		  Begin
			Insert into Cln_Settings Values (@Group, @Code, @Value) 
		  End

		Set @Ret = @@ROWCOUNT
	  end
	  
	Return @Ret
	
	Set nocount off

GO

-----------------------------------------------------------------
---- Create the procedure from the dll
-----------------------------------------------------------------
CREATE PROCEDURE Verify 
@Group nvarchar(50), -- In only, specify settings / parameter group
@Address_Name nvarchar(300) OUTPUT, /* IN/OUT - Full Name - will be parsed if specified */
@Company_Name nvarchar(256) OUTPUT,  /* IN/OUT */
@Attention nvarchar(256) OUTPUT, /* IN/OUT */
@Address nvarchar(256) OUTPUT ,  /* IN/OUT - House float and Street Address */
@Suite nvarchar(256) OUTPUT ,  /* IN/OUT - Suite / Apartment float */
@Private_Mailbox nvarchar(100) OUTPUT ,  /* Private Mail Box Facility */
-- Generic Address Lines 1-8
@Address_Line_1 nvarchar(256) OUTPUT ,  /* IN/OUT */
@Address_Line_2 nvarchar(256) OUTPUT ,  /* IN/OUT */
@Address_Line_3 nvarchar(256) OUTPUT ,  /* IN/OUT */
@Address_Line_4 nvarchar(256) OUTPUT ,  /* IN/OUT */ -- 10
@Address_Line_5 nvarchar(256) OUTPUT ,
@Address_Line_6 nvarchar(256) OUTPUT ,
@Address_Line_7 nvarchar(256) OUTPUT ,
@Address_Line_8 nvarchar(256) OUTPUT ,
-- Common Address Components
@City nvarchar(100) OUTPUT ,  /* IN/OUT */
@City_Abbreviation nvarchar(100) OUTPUT ,
@State nvarchar(100) OUTPUT ,  /* IN/OUT */
@Postal_Code nvarchar(50) OUTPUT ,   /* IN/OUT */
@Postal_Code_Extended nvarchar(50) OUTPUT ,   /* IN/OUT - ie ZIP+4 */
@Last_Line nvarchar(256) OUTPUT ,  /* Last Address Line: City@ State Zip-Plus4 (US Only) OUTPUT , */ -- 20
@Country_Code nvarchar(30) OUTPUT ,   /* IN/OUT */
@Country_Name nvarchar(100) OUTPUT ,  /* IN/OUT */
@Urbanization nvarchar(256) OUTPUT ,  /* IN/OUT - Puerto Rico Addresses Only */
@Province nvarchar(100) OUTPUT ,  /* IN/OUT - International Addresses */
@Carrier_Route nvarchar(20) OUTPUT ,
@Delivery_Point_Check_Digit nvarchar(10) OUTPUT ,
@Delivery_Point nvarchar(2) OUTPUT ,
@Check_Digit nvarchar(1) OUTPUT ,
-- Parsed Street Components - OUTPUTput only - not to be used as input
@Parsed_Address_Range nvarchar(60) OUTPUT ,
@Parsed_Address_float nvarchar(60) OUTPUT , -- 30
@Parsed_Pre_Direction nvarchar(40) OUTPUT ,
@Parsed_Street_Name nvarchar(100) OUTPUT ,
@Parsed_Street_Suffix nvarchar(40) OUTPUT ,
@Parse_Post_Direction nvarchar(40) OUTPUT ,
@Parsed_Unit_Type  nvarchar(40) OUTPUT ,
@Parsed_Unit_float  nvarchar(40) OUTPUT ,
@Parsed_Private_Mailbox_Type  nvarchar(40) OUTPUT ,  /* Private Mail Box Type (ie PMB) OUTPUT , */
@Parsed_Private_Mailbox_float nvarchar(40) OUTPUT ,  /* Private Mail Box float (ie 124B) out , */
-- Suggestion List - returns list of possible matches when an address is not verified
-- - The returned list is separated by ";" (semi-colon) out ,@ and can easily be replaced with a CR chr(10) out , or <BR>
-- - pass fn_error_suggest_count > 0 in the Verify or Verify_Generic procedure to activate this feature
-- - If fb_verbose_suggest_list is passed in as TRUE@ the results will contain street name detail for each line@
--   instead of an abbreviated results list where the street name does not repeat for multiple records
--   - The verbose option also puts a ":" (colon) out , delimiter between each field for a suggestion
@Suggestion_List nvarchar(4000) OUTPUT ,
-- Enhancement Address Fields
@County_Code nvarchar(20) OUTPUT , -- 40
@County_Name nvarchar(100) OUTPUT ,
@Timezone_Code nvarchar(5) OUTPUT ,
@Timezone_String nvarchar(100) OUTPUT ,
@Error_Code nvarchar(20) OUTPUT ,    /* Primary field to check for an address error (View: CLN_ADDRESS_ERRORS_V) out , */
@Error_String nvarchar(4000) OUTPUT ,
@Status_Code nvarchar(20) OUTPUT ,    /* Address Status code (View: CLN_ADDRESS_STATUS_V) out , */
@DPV_Status nvarchar(20) OUTPUT ,    /* Delivery Point Validation Status - AA BB RR are verified successfully */
@DPV_Error_Code nvarchar(20) OUTPUT ,    /* Decode of DPV_Status and Error_Code to return prominant error code */
@RBDI_Code nvarchar(20) OUTPUT ,    /* (R) out ,esidential / (B) out ,usiness Delivery Indicator (R/B) out , - EXTRA DATA OPTION */
@CMRA nvarchar(1) OUTPUT ,     /* Commercial Mail Receiving Agency (Y/N) out , */ -- 50
@Address_Type_Code nvarchar(20) OUTPUT ,
@Address_Type_String nvarchar(100) OUTPUT ,
@MSA nvarchar(20) OUTPUT ,
@PMSA nvarchar(20) OUTPUT ,
@Congressional_District nvarchar(20) OUTPUT ,
@LACS_Code nvarchar(20) OUTPUT ,    /* L = Address has undergone a conversion */
@Automation_Code nvarchar(20) OUTPUT ,    /* Y = Carrier Route sortation rates apply for this Postal Code */
@Facility_Code nvarchar(20) OUTPUT ,
@Zip_Type_Code nvarchar(20) OUTPUT ,    /* NULL = Standard; P = PO Box Only Postal Code; U = Unique for Organization (ie IRS) out ,; M = Military */
-- GeoCoder Fields
@Latitude float(24) OUTPUT, -- 60
@Longitude float(24) OUTPUT,
@Census_Tract nvarchar(10) OUTPUT ,
@Census_Block nvarchar(10) OUTPUT ,
-- Name Parse Fields
@First_Name nvarchar(100) OUTPUT ,   /* IN/OUT */
@Middle_Name nvarchar(100) OUTPUT ,   /* IN/OUT */
@Last_Name nvarchar(100) OUTPUT ,   /* IN/OUT */
@Name_Prefix nvarchar(50) OUTPUT ,   /* IN/OUT */
@Name_Suffix nvarchar(50) OUTPUT ,   /* IN/OUT */
@Standardized_First_Name nvarchar(100) OUTPUT , /* Now IN/OUT */
@Gender nvarchar(50) OUTPUT ,    /* M = Male; F = Female; N = Neutral; U = Unknown */ -- 70
@First_Name_2 nvarchar(100) OUTPUT ,
@Middle_Name_2 nvarchar(100) OUTPUT ,
@Last_Name_2 nvarchar(100) OUTPUT ,
@Name_Prefix_2 nvarchar(50) OUTPUT ,
@Name_Suffix_2 nvarchar(50) OUTPUT ,
@Standardized_First_Name_2 nvarchar(100) OUTPUT ,
@Gender_2 nvarchar(50) OUTPUT ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@Name_Parse_Status_Code nvarchar(20) OUTPUT ,   /* ' ' = Successful Parse; 'V' = Vulgar world found; 'X' = Unable to Parse */
-- Telephone Check Fields
@Phone_float nvarchar(30) OUTPUT ,   /* IN/OUT */
@Phone_float_Output_Format nvarchar(30) ,   /* Format mask to apply for output - Use # for place holder@ ie (###) out ,###-#### */ -- 80
@New_Phone_float nvarchar(30) OUTPUT ,
@New_Phone_Area_Code nvarchar(15) OUTPUT ,
@Phone_Area_Code nvarchar(15) OUTPUT ,   /* IN/OUT */
@Phone_Prefix nvarchar(15) OUTPUT ,   /* IN/OUT */
@Phone_Suffix nvarchar(15) OUTPUT ,   /* IN/OUT */
@Phone_Extension nvarchar(15) OUTPUT ,
@Phone_Distance float(24) OUTPUT ,
@Phone_Check_Status_Code nvarchar(20) OUTPUT ,
@Phone_Check_Error_Code nvarchar(20) OUTPUT,
-- New fields - 2015-06-05 - dcn
@AddressKey nvarchar(100) OUTPUT,
@CountyFIPS nvarchar(100) OUTPUT,
@CountyName nvarchar(100) OUTPUT,
--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
@Standardized_Middle_Name nvarchar(100) OUTPUT,
@Results nvarchar(4000) OUTPUT,
@GenericAddressLineFormat nvarchar(100) OUTPUT,
@CBSACode nvarchar(100) OUTPUT,
@CBSATitle nvarchar(100) OUTPUT,
@CBSALevel nvarchar(100) OUTPUT,
@CBSADivisionCode nvarchar(100) OUTPUT,
@CBSADivisionTitle nvarchar(100) OUTPUT,
@CBSADivisionLevel nvarchar(100) OUTPUT
--
AS EXTERNAL NAME CLEAN_Address_CLR.StoredProcedures.Verify 
go

-- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Clean_Field]
(
  @sIn nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @SOut nvarchar(4000)
	
	set @SOut = isnull(@sIn,' ')
	if @SOut = 'null' Set @SOut = ' '
		
	return @SOut
END

GO
---- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Get_DPV_Status]
(
  @Code nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @Description nvarchar(4000)
	--Declare @code nvarchar(50)
	--set @code = 'U'
	select @Description = max([DESCRIPTION])
	--select *
	from Cln_Lookups
	--where LOOKUP_TYPE_CODE in ('DPVSTATUS', 'ADDRERROR')
	where LOOKUP_TYPE_CODE = 'DPVSTATUS'
	and CODE = @Code
	
	set @Description = isnull(@Description,'')
	
	return @Description
END

GO

-- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Help_DPV_Status]
(
  @Code nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @HelpText nvarchar(4000)
	
	select @HelpText = [HELP_TEXT] from Cln_Lookups
	where LOOKUP_TYPE_CODE = 'DPVSTATUS'
	and CODE = @Code
	
	set @HelpText = isnull(@HelpText,'')
	
	return @HelpText
END

GO

-- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Get_Address_Status]
(
  @Code nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @Description nvarchar(4000)
	
	select @Description = [DESCRIPTION] from Cln_Lookups
	where LOOKUP_TYPE_CODE = 'ADDRSTATUS'
	and CODE = @Code
	
	set @Description = isnull(@Description,'')
	
	return @Description
END

go

-- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Get_Address_Error]
(
  @Code nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @Description nvarchar(4000)
	
	select @Description = [DESCRIPTION] 
	from Cln_Lookups
	where LOOKUP_TYPE_CODE = 'ADDRERROR'	
	and CODE = @Code
	
	set @Description = isnull(@Description,'')
	
	return @Description
END

go

-- Version 1.0 - 2011-04-27
create FUNCTION [dbo].[Get_Country_Name]
(
  @Code nvarchar(4000)
)
RETURNS nvarchar(4000)
AS
BEGIN
	Declare @Description nvarchar(4000)
	
	If @Code is not null and len(@Code) >= 2
	  begin
		select @Description = [DESCRIPTION] 
		from Cln_Lookups
		where LOOKUP_TYPE_CODE = 'COUNTRY'	
		and CODE = substring(@Code,1,2)
	  end
	  
	set @Description = isnull(@Description,'')
	
	return @Description
END

go
GO

CREATE TABLE [dbo].[Cln_Lookups](
	[LOOKUP_ID] [int] NOT NULL,
	[COUNTRY_CODE] [nvarchar](255) NULL,
	[LOOKUP_TYPE_CODE] [nvarchar](255) NULL,
	[CODE] [nvarchar](255) NULL,
	[DESCRIPTION] [nvarchar](255) NULL,
	[SORT_ORDER] [nvarchar](255) NULL,
	[INACTIVE_FLAG] [float] NULL,
	[INACTIVE_DATE] [datetime] NULL,
	[START_TIME_DATE] [datetime] NULL,
	[END_TIME_DATE] [datetime] NULL,
	[COMMENT_TEXT] [nvarchar](255) NULL,
	[HELP_TEXT] [nvarchar](max) NULL,
	[NOTE_TEXT] [nvarchar](255) NULL,
	[CREATED_DATE] [datetime] NULL,
	[CREATED_USER] [nvarchar](255) NULL,
	[UPDATED_DATE] [datetime] NULL,
	[UPDATED_USER] [nvarchar](255) NULL,
	[UPDATED_COUNT] [float] NULL,
	[FLEX_1_FLAG] [float] NULL,
	[FLEX_2_FLAG] [float] NULL,
	[FLEX_3_FLAG] [float] NULL,
	[FLEX_4_FLAG] [float] NULL,
	[FLEX_5_FLAG] [float] NULL,
	[FLEX_1] [nvarchar](255) NULL,
	[FLEX_2] [nvarchar](255) NULL,
	[FLEX_3] [nvarchar](255) NULL,
	[FLEX_4] [nvarchar](255) NULL,
	[FLEX_5] [nvarchar](255) NULL,
 CONSTRAINT [PK_Cln_Lookups] PRIMARY KEY CLUSTERED 
(
	[LOOKUP_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

insert into Cln_Lookups select 1001, '','ADDRERROR','M','Multiple Matches','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','More than one record matches the address and there is not enough information available in the input address to break the tie between multiple records. Passing information, such as city names or urbanization names, can help reduce the number of multiple match errors.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1002, '','ADDRERROR','N','No Street Data for ZIP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The ZIP Code exists but no streets begin with the same letter in that ZIP Code.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1003, '','ADDRERROR','R','Address out of Range','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The address was found but the street number in the input address was not between the low and high range of the post office database.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1004, '','ADDRERROR','T','Component Mismatch','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Either the directionals or the suffix field did not match the post office database, and there was more than one choice for correcting the address. For example, if the given address was ?100 Main St? and the only addresses found were ?100 E Main St? and ?100 Main Ave?, the error code ?T? would be returned because we do not know whether to add the directional ?E? or to change the suffix to ?Ave?.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1005, '','ADDRERROR','U','Unknown Street','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','An exact street name match could not be found and phonetically matching the street name resulted in either no matches or matches to more than one street name.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1006, '','ADDRERROR','X','Non-Deliverable Address','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The physical location exists but there are no homes on this street. One reason might be railroad tracks or rivers running alongside this street, as they would prevent construction of homes in this location.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1007, '','ADDRERROR','Z','ZIP Code Error','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The ZIP Code does not exist and could not be determined by the city and state.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1008, '','ADDRERROR','C','Canadian ZIP Code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The ZIP Code matches the format characteristics of a Canadian ZIP Code.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1009, '','ADDRERROR','D','DEMO Mode Only','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The ZIP Code is out of range for this DEMO version of Address Object.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1010, '','ADDRSTATUS','E','Expired database','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1011, '','ADDRSTATUS','X','Address was not coded','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Check the Address Error Code to find out why the address did not code','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',5,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1012, '','ADDRSTATUS','S','The address was standardized but not coded','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Standardization means that some conversion was done on the address (i.e. changing Post Office Box to PO Box or abbreviating street suffixes)','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1013, '','ADDRSTATUS','5','Multiple matches for address in same ZIP code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','There were multiple matches for the address but they were all in the same ZIP Code. The returned ZIP Code will be correct but you will not get any carrier route or +4 information','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1014, '','ADDRSTATUS','7','Multiple matches for address in same ZIP code and carrier route','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','There were multiple matches for the address but they were all in the same ZIP Code and carrier route. The returned ZIP Code and carrier route will be correct but you will not get any +4 information','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1015, '','ADDRSTATUS','9','The address was fully coded','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',5,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 1016, '','ADDRTYPE','F','Firm or Company','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1017, '','ADDRTYPE','G','General Delivery','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1018, '','ADDRTYPE','H','Highrise or Business Complex','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1019, '','ADDRTYPE','P','PO Box','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1020, '','ADDRTYPE','R','Rural Route','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1021, '','ADDRTYPE','S','Street or Residential','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1022, '','AUTOMATION','A','Carrier Route rates are available (Y) and merging is permitted (Y)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1023, '','AUTOMATION','B','Carrier Route rates are available (Y) and merging is not permitted (N)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1024, '','AUTOMATION','C','Carrier Route rates are not available (N) and merging is permitted (Y)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1025, '','AUTOMATION','D','Carrier Route rates are not available (N) and merging is not permitted (N)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1026, '','CARRROUTE','B','PO Box','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1027, '','CARRROUTE','C','City Delivery','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1028, '','CARRROUTE','G','General Delivery','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1029, '','CARRROUTE','H','Highway Contract','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1030, '','CARRROUTE','R','Rural Route','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1031, 'US','COUNTRY','US','United States','10',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1032, 'CA','COUNTRY','CA','Canada','20',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1033, 'AL','COUNTRY','AL','Albania','30',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+355','','','',''
insert into Cln_Lookups select 1034, 'DZ','COUNTRY','DZ','Algeria','40',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+21','','','',''
insert into Cln_Lookups select 1035, 'AS','COUNTRY','AS','American Samoa','50',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+684','','','',''
insert into Cln_Lookups select 1036, 'AD','COUNTRY','AD','Andorra','60',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+376','','','',''
insert into Cln_Lookups select 1037, 'AO','COUNTRY','AO','Angola','70',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+244','','','',''
insert into Cln_Lookups select 1038, 'AI','COUNTRY','AI','Anguilla','80',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-264','','','',''
insert into Cln_Lookups select 1039, 'AG','COUNTRY','AG','Antigua and Barbuda','90',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-268','','','',''
insert into Cln_Lookups select 1040, 'AR','COUNTRY','AR','Argentina','100',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+54','','','',''
insert into Cln_Lookups select 1041, 'AM','COUNTRY','AM','Armenia','110',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1042, 'AW','COUNTRY','AW','Aruba','120',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1043, 'AU','COUNTRY','AU','Australia','130',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+61','','','',''
insert into Cln_Lookups select 1044, 'AT','COUNTRY','AT','Austria','140',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+43','','','',''
insert into Cln_Lookups select 1045, 'AP','COUNTRY','AP','Azores','150',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1046, 'BS','COUNTRY','BS','Bahamas','160',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-242','','','',''
insert into Cln_Lookups select 1047, 'BH','COUNTRY','BH','Bahrain','170',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+973','','','',''
insert into Cln_Lookups select 1048, 'BD','COUNTRY','BD','Bangladesh','180',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+880','','','',''
insert into Cln_Lookups select 1049, 'BB','COUNTRY','BB','Barbados','190',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-246','','','',''
insert into Cln_Lookups select 1050, 'BY','COUNTRY','BY','Belarus','200',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+375','','','',''
insert into Cln_Lookups select 1051, 'BE','COUNTRY','BE','Belgium','210',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+32','','','',''
insert into Cln_Lookups select 1052, 'BZ','COUNTRY','BZ','Belize','220',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+501','','','',''
insert into Cln_Lookups select 1053, 'BJ','COUNTRY','BJ','Benin','230',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+229','','','',''
insert into Cln_Lookups select 1054, 'BT','COUNTRY','BT','Bhutan','240',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1055, 'BM','COUNTRY','BM','Bermuda','250',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-441','','','',''
insert into Cln_Lookups select 1056, 'BO','COUNTRY','BO','Bolivia','260',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+591','','','',''
insert into Cln_Lookups select 1057, 'BL','COUNTRY','BL','Bonaire','270',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1058, 'BA','COUNTRY','BA','Bosnia and Herzegovina','280',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+387','','','',''
insert into Cln_Lookups select 1059, 'BW','COUNTRY','BW','Botswana','290',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+267','','','',''
insert into Cln_Lookups select 1060, 'BR','COUNTRY','BR','Brazil','300',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+55','','','',''
insert into Cln_Lookups select 1061, 'VG','COUNTRY','VG','British Virgin Islands','310',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-284','','','',''
insert into Cln_Lookups select 1062, 'BN','COUNTRY','BN','Brunei Darussalam','320',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+673','','','',''
insert into Cln_Lookups select 1063, 'BG','COUNTRY','BG','Bulgaria','330',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+359','','','',''
insert into Cln_Lookups select 1064, 'BF','COUNTRY','BF','Burkina Faso','340',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+226','','','',''
insert into Cln_Lookups select 1065, 'BI','COUNTRY','BI','Burundi','350',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+257','','','',''
insert into Cln_Lookups select 1066, 'KH','COUNTRY','KH','Cambodia','360',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+855','','','',''
insert into Cln_Lookups select 1067, 'CM','COUNTRY','CM','Cameroon','370',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+237','','','',''
insert into Cln_Lookups select 1068, 'CE','COUNTRY','CE','Canary Islands','380',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1069, 'CV','COUNTRY','CV','Cape Verde','390',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+238','','','',''
insert into Cln_Lookups select 1070, 'KY','COUNTRY','KY','Cayman Islands','400',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-345','','','',''
insert into Cln_Lookups select 1071, 'CF','COUNTRY','CF','Central African Republic','410',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+236','','','',''
insert into Cln_Lookups select 1072, 'TD','COUNTRY','TD','Chad','420',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+235','','','',''
insert into Cln_Lookups select 1073, 'NN','COUNTRY','NN','Channel Islands','430',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1074, 'CL','COUNTRY','CL','Chile','440',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+56','','','',''
insert into Cln_Lookups select 1075, 'CN','COUNTRY','CN','China','450',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+86','','','',''
insert into Cln_Lookups select 1076, 'CO','COUNTRY','CO','Colombia','460',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+57','','','',''
insert into Cln_Lookups select 1077, 'CG','COUNTRY','CG','Congo','470',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+242','','','',''
insert into Cln_Lookups select 1078, 'CK','COUNTRY','CK','Cook Islands','480',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+682','','','',''
insert into Cln_Lookups select 1079, 'CR','COUNTRY','CR','Costa Rica','490',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+506','','','',''
insert into Cln_Lookups select 1080, 'HR','COUNTRY','HR','Croatia','500',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+385','','','',''
insert into Cln_Lookups select 1081, 'CB','COUNTRY','CB','Curacao','510',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1082, 'CY','COUNTRY','CY','Cyprus','520',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+357','','','',''
insert into Cln_Lookups select 1083, 'CZ','COUNTRY','CZ','Czech Republic','530',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+420','','','',''
insert into Cln_Lookups select 1084, 'DK','COUNTRY','DK','Denmark','540',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+45','','','',''
insert into Cln_Lookups select 1085, 'DJ','COUNTRY','DJ','Djibouti','550',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+253','','','',''
insert into Cln_Lookups select 1086, 'DM','COUNTRY','DM','Dominica','560',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-767','','','',''
insert into Cln_Lookups select 1087, 'DO','COUNTRY','DO','Dominican Republic','570',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-809','','','',''
insert into Cln_Lookups select 1088, 'EC','COUNTRY','EC','Ecuador','580',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+593','','','',''
insert into Cln_Lookups select 1089, 'EG','COUNTRY','EG','Egypt','590',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+20','','','',''
insert into Cln_Lookups select 1090, 'SV','COUNTRY','SV','El Salvador','600',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+503','','','',''
insert into Cln_Lookups select 1091, 'EN','COUNTRY','EN','England','610',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1092, 'GQ','COUNTRY','GQ','Equatorial Guinea','620',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+240','','','',''
insert into Cln_Lookups select 1093, 'ER','COUNTRY','ER','Eritrea','630',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1094, 'EE','COUNTRY','EE','Estonia','640',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+372','','','',''
insert into Cln_Lookups select 1095, 'ET','COUNTRY','ET','Ethiopia','650',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+251','','','',''
insert into Cln_Lookups select 1096, 'FO','COUNTRY','FO','Faroe Islands','660',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+298','','','',''
insert into Cln_Lookups select 1097, 'FJ','COUNTRY','FJ','Fiji','670',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+679','','','',''
insert into Cln_Lookups select 1098, 'FI','COUNTRY','FI','Finland','680',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+358','','','',''
insert into Cln_Lookups select 1099, 'FR','COUNTRY','FR','France','690',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+33','','','',''
insert into Cln_Lookups select 1100, 'GF','COUNTRY','GF','French Guiana','700',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+594','','','',''
insert into Cln_Lookups select 1101, 'PF','COUNTRY','PF','French Polynesia','710',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+689','','','',''
insert into Cln_Lookups select 1102, 'GA','COUNTRY','GA','Gabon','720',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+241','','','',''
insert into Cln_Lookups select 1103, 'GM','COUNTRY','GM','Gambia','730',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+220','','','',''
insert into Cln_Lookups select 1104, 'GE','COUNTRY','GE','Georgia','740',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+995','','','',''
insert into Cln_Lookups select 1105, 'DE','COUNTRY','DE','Germany','750',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+49','','','',''
insert into Cln_Lookups select 1106, 'GH','COUNTRY','GH','Ghana','760',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+233','','','',''
insert into Cln_Lookups select 1107, 'GI','COUNTRY','GI','Gibraltar','770',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+350','','','',''
insert into Cln_Lookups select 1108, 'GB','COUNTRY','GB','United Kingdom','780',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+44','','','',''
insert into Cln_Lookups select 1109, 'GR','COUNTRY','GR','Greece','790',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+30','','','',''
insert into Cln_Lookups select 1110, 'GL','COUNTRY','GL','Greenland','800',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+299','','','',''
insert into Cln_Lookups select 1111, 'GD','COUNTRY','GD','Grenada','810',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-473','','','',''
insert into Cln_Lookups select 1112, 'GP','COUNTRY','GP','Guadeloupe','820',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1113, 'GU','COUNTRY','GU','Guam','830',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+671','','','',''
insert into Cln_Lookups select 1114, 'GT','COUNTRY','GT','Guatemala','840',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+502','','','',''
insert into Cln_Lookups select 1115, 'GN','COUNTRY','GN','Guinea','850',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+224','','','',''
insert into Cln_Lookups select 1116, 'GW','COUNTRY','GW','Guinea-Bissau','860',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+245','','','',''
insert into Cln_Lookups select 1117, 'GY','COUNTRY','GY','Guyana','870',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+592','','','',''
insert into Cln_Lookups select 1118, 'HT','COUNTRY','HT','Haiti','880',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+509','','','',''
insert into Cln_Lookups select 1119, 'HN','COUNTRY','HN','Honduras','890',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+504','','','',''
insert into Cln_Lookups select 1120, 'HK','COUNTRY','HK','Hong Kong','900',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+852','','','',''
insert into Cln_Lookups select 1121, 'HU','COUNTRY','HU','Hungary','910',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+36','','','',''
insert into Cln_Lookups select 1122, 'IS','COUNTRY','IS','Iceland','920',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+354','','','',''
insert into Cln_Lookups select 1123, 'IN','COUNTRY','IN','India','930',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+91','','','',''
insert into Cln_Lookups select 1124, 'ID','COUNTRY','ID','Indonesia','940',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+62','','','',''
insert into Cln_Lookups select 1125, 'IE','COUNTRY','IE','Ireland','950',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+353','','','',''
insert into Cln_Lookups select 1126, 'IL','COUNTRY','IL','Israel','960',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+972','','','',''
insert into Cln_Lookups select 1127, 'IT','COUNTRY','IT','Italy','970',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+39','','','',''
insert into Cln_Lookups select 1128, 'CI','COUNTRY','CI','Ivory Coast','980',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+225','','','',''
insert into Cln_Lookups select 1129, 'JM','COUNTRY','JM','Jamaica','990',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-876','','','',''
insert into Cln_Lookups select 1130, 'JP','COUNTRY','JP','Japan','1000',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+81','','','',''
insert into Cln_Lookups select 1131, 'JO','COUNTRY','JO','Jordan','1010',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+962','','','',''
insert into Cln_Lookups select 1132, 'KZ','COUNTRY','KZ','Kazakhstan','1020',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1133, 'KE','COUNTRY','KE','Kenya','1030',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+254','','','',''
insert into Cln_Lookups select 1134, 'KI','COUNTRY','KI','Kiribati','1040',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+686','','','',''
insert into Cln_Lookups select 1135, 'KO','COUNTRY','KO','Kosrae','1050',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1136, 'KR','COUNTRY','KR','South Korea','1060',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+82','','','',''
insert into Cln_Lookups select 1137, 'KW','COUNTRY','KW','Kuwait','1070',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+965','','','',''
insert into Cln_Lookups select 1138, 'KG','COUNTRY','KG','Kyrgyzstan','1080',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1139, 'LA','COUNTRY','LA','Laos','1090',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+856','','','',''
insert into Cln_Lookups select 1140, 'LV','COUNTRY','LV','Latvia','1100',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+371','','','',''
insert into Cln_Lookups select 1141, 'LB','COUNTRY','LB','Lebanon','1110',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+961','','','',''
insert into Cln_Lookups select 1142, 'LS','COUNTRY','LS','Lesotho','1120',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+266','','','',''
insert into Cln_Lookups select 1143, 'LR','COUNTRY','LR','Liberia','1130',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+231','','','',''
insert into Cln_Lookups select 1144, 'LI','COUNTRY','LI','Liechtenstein','1140',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+41','','','',''
insert into Cln_Lookups select 1145, 'LT','COUNTRY','LT','Lithuania','1150',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+370','','','',''
insert into Cln_Lookups select 1146, 'LU','COUNTRY','LU','Luxembourg','1160',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+352','','','',''
insert into Cln_Lookups select 1147, 'MO','COUNTRY','MO','Macau','1170',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+853','','','',''
insert into Cln_Lookups select 1148, 'MK','COUNTRY','MK','Macedonia','1180',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+389','','','',''
insert into Cln_Lookups select 1149, 'MG','COUNTRY','MG','Madagascar','1190',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+261','','','',''
insert into Cln_Lookups select 1150, 'ME','COUNTRY','ME','Madeira Islands','1200',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1151, 'MW','COUNTRY','MW','Malawi','1210',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+265','','','',''
insert into Cln_Lookups select 1152, 'MY','COUNTRY','MY','Malaysia','1220',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+60','','','',''
insert into Cln_Lookups select 1153, 'MV','COUNTRY','MV','Maldives','1230',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+960','','','',''
insert into Cln_Lookups select 1154, 'ML','COUNTRY','ML','Mali','1240',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+223','','','',''
insert into Cln_Lookups select 1155, 'MT','COUNTRY','MT','Malta','1250',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+356','','','',''
insert into Cln_Lookups select 1156, 'MH','COUNTRY','MH','Marshall Islands','1260',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+692','','','',''
insert into Cln_Lookups select 1157, 'MQ','COUNTRY','MQ','Martinique','1270',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+596','','','',''
insert into Cln_Lookups select 1158, 'MR','COUNTRY','MR','Mauritania','1280',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+222','','','',''
insert into Cln_Lookups select 1159, 'MU','COUNTRY','MU','Mauritius','1290',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+230','','','',''
insert into Cln_Lookups select 1160, 'MX','COUNTRY','MX','Mexico','1300',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+52','','','',''
insert into Cln_Lookups select 1161, 'FM','COUNTRY','FM','Micronesia','1310',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+691','','','',''
insert into Cln_Lookups select 1162, 'MD','COUNTRY','MD','Moldova','1320',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1163, 'MC','COUNTRY','MC','Monaco','1330',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+377','','','',''
insert into Cln_Lookups select 1164, 'MS','COUNTRY','MS','Montserrat','1340',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-664','','','',''
insert into Cln_Lookups select 1165, 'MA','COUNTRY','MA','Morocco','1350',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+212','','','',''
insert into Cln_Lookups select 1166, 'MZ','COUNTRY','MZ','Mozambique','1360',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+258','','','',''
insert into Cln_Lookups select 1167, 'MM','COUNTRY','MM','Myanmar','1370',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+95','','','',''
insert into Cln_Lookups select 1168, 'NA','COUNTRY','NA','Namibia','1380',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+264','','','',''
insert into Cln_Lookups select 1169, 'NP','COUNTRY','NP','Nepal','1390',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+977','','','',''
insert into Cln_Lookups select 1170, 'NL','COUNTRY','NL','Netherlands','1400',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+31','','','',''
insert into Cln_Lookups select 1171, 'AN','COUNTRY','AN','Netherlands Antilles','1410',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+599','','','',''
insert into Cln_Lookups select 1172, 'NC','COUNTRY','NC','New Caledonia','1420',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+687','','','',''
insert into Cln_Lookups select 1173, 'NZ','COUNTRY','NZ','New Zealand','1430',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+64','','','',''
insert into Cln_Lookups select 1174, 'NI','COUNTRY','NI','Nicaragua','1440',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+505','','','',''
insert into Cln_Lookups select 1175, 'NE','COUNTRY','NE','Niger','1450',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+227','','','',''
insert into Cln_Lookups select 1176, 'NG','COUNTRY','NG','Nigeria','1460',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+234','','','',''
insert into Cln_Lookups select 1177, 'NF','COUNTRY','NF','Norfolk Island','1470',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+672','','','',''
insert into Cln_Lookups select 1178, 'KRN','COUNTRY','KRN','North Korea','1480',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Dec 15 2000  5:56PM','CLNADDR',1,0,0,0,0,0,'+850','','','',''
insert into Cln_Lookups select 1179, 'YEN','COUNTRY','YEN','North Yemen','1490',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+967','','','',''
insert into Cln_Lookups select 1180, 'NB','COUNTRY','NB','Northern Ireland','1500',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1181, 'MP','COUNTRY','MP','Northern Mariana Islands','1510',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+670','','','',''
insert into Cln_Lookups select 1182, 'NO','COUNTRY','NO','Norway','1520',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+47','','','',''
insert into Cln_Lookups select 1183, 'OM','COUNTRY','OM','Oman','1530',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+968','','','',''
insert into Cln_Lookups select 1184, 'PK','COUNTRY','PK','Pakistan','1540',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+92','','','',''
insert into Cln_Lookups select 1185, 'PW','COUNTRY','PW','Palau','1550',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1186, 'PA','COUNTRY','PA','Panama','1560',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+507','','','',''
insert into Cln_Lookups select 1187, 'PG','COUNTRY','PG','Papua New Guinea','1570',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+675','','','',''
insert into Cln_Lookups select 1188, 'PY','COUNTRY','PY','Paraguay','1580',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+595','','','',''
insert into Cln_Lookups select 1189, 'PE','COUNTRY','PE','Peru','1590',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+51','','','',''
insert into Cln_Lookups select 1190, 'PH','COUNTRY','PH','Philippines','1600',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+63','','','',''
insert into Cln_Lookups select 1191, 'PL','COUNTRY','PL','Poland','1610',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+48','','','',''
insert into Cln_Lookups select 1192, 'PO','COUNTRY','PO','Ponape','1620',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1193, 'PT','COUNTRY','PT','Portugal','1630',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+351','','','',''
insert into Cln_Lookups select 1194, 'PR','COUNTRY','PR','Puerto Rico','1640',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-787','','','',''
insert into Cln_Lookups select 1195, 'QA','COUNTRY','QA','Qatar','1650',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+974','','','',''
insert into Cln_Lookups select 1196, 'RE','COUNTRY','RE','Reunion','1660',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+262','','','',''
insert into Cln_Lookups select 1197, 'RO','COUNTRY','RO','Romania','1670',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+40','','','',''
insert into Cln_Lookups select 1198, 'RT','COUNTRY','RT','Rota','1680',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1199, 'RU','COUNTRY','RU','Russian Federation','1690',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+7','','','',''
insert into Cln_Lookups select 1200, 'RW','COUNTRY','RW','Rwanda','1700',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+250','','','',''
insert into Cln_Lookups select 1201, 'SS','COUNTRY','SS','Saba','1710',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1202, 'SP','COUNTRY','SP','Saipan','1720',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1203, 'ST','COUNTRY','ST','Sao Tome and Principe','1730',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+239','','','',''
insert into Cln_Lookups select 1204, 'SA','COUNTRY','SA','Saudi Arabia','1740',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+966','','','',''
insert into Cln_Lookups select 1205, 'SF','COUNTRY','SF','Scotland','1750',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1206, 'SN','COUNTRY','SN','Senegal','1760',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+221','','','',''
insert into Cln_Lookups select 1207, 'SC','COUNTRY','SC','Seychelles','1770',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+248','','','',''
insert into Cln_Lookups select 1208, 'SL','COUNTRY','SL','Sierra Leone','1780',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+232','','','',''
insert into Cln_Lookups select 1209, 'SG','COUNTRY','SG','Singapore','1790',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+65','','','',''
insert into Cln_Lookups select 1210, 'SK','COUNTRY','SK','Slovakia','1800',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+421','','','',''
insert into Cln_Lookups select 1211, 'SI','COUNTRY','SI','Slovenia','1810',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+386','','','',''
insert into Cln_Lookups select 1212, 'SB','COUNTRY','SB','Solomon Islands','1820',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+677','','','',''
insert into Cln_Lookups select 1213, 'ZA','COUNTRY','ZA','South Africa','1830',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+27','','','',''
insert into Cln_Lookups select 1214, 'KRS','COUNTRY','KRS','South Korea','1840',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Dec 15 2000  5:56PM','CLNADDR',1,0,0,0,0,0,'+82','','','',''
insert into Cln_Lookups select 1215, 'YES','COUNTRY','YES','South Yemen','1850',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+969','','','',''
insert into Cln_Lookups select 1216, 'ES','COUNTRY','ES','Spain','1860',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+34','','','',''
insert into Cln_Lookups select 1217, 'LK','COUNTRY','LK','Sri Lanka','1870',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+94','','','',''
insert into Cln_Lookups select 1218, 'NT','COUNTRY','NT','St. Barthelemy','1880',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1219, 'SW','COUNTRY','SW','St. Christopher','1890',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1220, 'SX','COUNTRY','SX','St. Croix','1900',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1221, 'EU','COUNTRY','EU','St. Eustatius','1910',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1222, 'UV','COUNTRY','UV','St. John','1920',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1223, 'KN','COUNTRY','KN','Saint Kitts and Nevis','1930',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-869','','','',''
insert into Cln_Lookups select 1224, 'LC','COUNTRY','LC','Saint Lucia','1940',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-758','','','',''
insert into Cln_Lookups select 1225, 'MB','COUNTRY','MB','St. Maarten','1950',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1226, 'TB','COUNTRY','TB','St. Martin','1960',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1227, 'VL','COUNTRY','VL','St. Thomas','1970',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1228, 'VC','COUNTRY','VC','Saint Vincent and the Grenadines','1980',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-784','','','',''
insert into Cln_Lookups select 1229, 'SD','COUNTRY','SD','Sudan','1990',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+249','','','',''
insert into Cln_Lookups select 1230, 'SR','COUNTRY','SR','Suriname','2000',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+597','','','',''
insert into Cln_Lookups select 1231, 'SZ','COUNTRY','SZ','Swaziland','2010',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+268','','','',''
insert into Cln_Lookups select 1232, 'SE','COUNTRY','SE','Sweden','2020',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+46','','','',''
insert into Cln_Lookups select 1233, 'CH','COUNTRY','CH','Switzerland','2030',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+41','','','',''
insert into Cln_Lookups select 1234, 'SY','COUNTRY','SY','Syria','2040',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+963','','','',''
insert into Cln_Lookups select 1235, 'TA','COUNTRY','TA','Tahiti','2050',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1236, 'TW','COUNTRY','TW','Taiwan','2060',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+886','','','',''
insert into Cln_Lookups select 1237, 'TJ','COUNTRY','TJ','Tajikistan','2070',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1238, 'TZ','COUNTRY','TZ','Tanzania','2080',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+255','','','',''
insert into Cln_Lookups select 1239, 'TH','COUNTRY','TH','Thailand','2090',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+66','','','',''
insert into Cln_Lookups select 1240, 'TG','COUNTRY','TG','Togo','2100',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+228','','','',''
insert into Cln_Lookups select 1241, 'TO','COUNTRY','TO','Tonga','2110',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+676','','','',''
insert into Cln_Lookups select 1242, 'TT','COUNTRY','TT','Trinidad and Tobago','2120',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-868','','','',''
insert into Cln_Lookups select 1243, 'TU','COUNTRY','TU','Truk','2130',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1244, 'TN','COUNTRY','TN','Tunisia','2140',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+21','','','',''
insert into Cln_Lookups select 1245, 'TR','COUNTRY','TR','Turkey','2150',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+90','','','',''
insert into Cln_Lookups select 1246, 'TM','COUNTRY','TM','Turkmenistan','2160',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1247, 'TC','COUNTRY','TC','Turks and Caicos Islands','2170',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-649','','','',''
insert into Cln_Lookups select 1248, 'TV','COUNTRY','TV','Tuvalu','2180',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+688','','','',''
insert into Cln_Lookups select 1249, 'UG','COUNTRY','UG','Uganda','2190',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+256','','','',''
insert into Cln_Lookups select 1250, 'UA','COUNTRY','UA','Ukraine','2200',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+380','','','',''
insert into Cln_Lookups select 1251, 'AE','COUNTRY','AE','United Arab Emirates','2210',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+971','','','',''
insert into Cln_Lookups select 1252, 'UK','COUNTRY','UK','United Kingdom','2220',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Dec 15 2000  5:56PM','CLNADDR',1,0,0,0,0,0,'+44','','','',''
insert into Cln_Lookups select 1253, 'UY','COUNTRY','UY','Uruguay','2230',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+598','','','',''
insert into Cln_Lookups select 1254, 'VI','COUNTRY','VI','US Virgin Islands','2240',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+1-340','','','',''
insert into Cln_Lookups select 1255, 'UZ','COUNTRY','UZ','Uzbekistan','2250',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1256, 'VU','COUNTRY','VU','Vanuatu','2260',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+678','','','',''
insert into Cln_Lookups select 1257, 'VE','COUNTRY','VE','Venezuela','2270',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+58','','','',''
insert into Cln_Lookups select 1258, 'VN','COUNTRY','VN','Vietnam','2280',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+84','','','',''
insert into Cln_Lookups select 1259, 'WK','COUNTRY','WK','Wake Island','2290',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1260, 'WL','COUNTRY','WL','Wales','2300',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1261, 'WF','COUNTRY','WF','Wallis and Futuna Islands','2310',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+681','','','',''
insert into Cln_Lookups select 1262, 'WS','COUNTRY','WS','Samoa','2320',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+685','','','',''
insert into Cln_Lookups select 1263, 'YA','COUNTRY','YA','Yap','2330',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1264, 'YE','COUNTRY','YE','Yemen','2340',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1265, 'YU','COUNTRY','YU','Yugoslavia','2350',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+381','','','',''
insert into Cln_Lookups select 1266, 'ZR','COUNTRY','ZR','Zaire','2360',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+243','','','',''
insert into Cln_Lookups select 1267, 'ZM','COUNTRY','ZM','Zambia','2370',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+260','','','',''
insert into Cln_Lookups select 1268, 'ZW','COUNTRY','ZW','Zimbabwe','2380',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'+263','','','',''
insert into Cln_Lookups select 1269, '','COUNTYNAMETYPE','A','Census Area','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1270, '','COUNTYNAMETYPE','B','Borough','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1271, '','COUNTYNAMETYPE','C','County','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1272, '','COUNTYNAMETYPE','D','District','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1273, '','COUNTYNAMETYPE','M','Municipio','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1274, '','COUNTYNAMETYPE','P','Parish','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1275, '','COUNTYSIZE','A','Counties within the 25 largest MSA''s','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1276, '','COUNTYSIZE','B','Counties with population > 150,000 not in A','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1277, '','COUNTYSIZE','C','Counties with population > 35,000 not in A or B','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1278, '','COUNTYSIZE','D','Counties with population < 35,000 not in A, B, or C','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1279, '','EMAILSTATUS','D','Missing Domain - No @','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1280, '','EMAILSTATUS','S','Missing Domain Suffix - No . after @','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1281, '','EMAILSTATUS','N','Missing Email Name - No text before @','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1282, '','EMAILSTATUS','L','Domain Suffix Too Long','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1283, '','EMAILSTATUS','U','Unknown Domain - Duplicate @','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1284, '','EMAILSTATUS','I','Invalid Character Found','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1285, '','EMAILSTATUS','P','Failed Ping Test','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1286, '','FACILITY','A','Airport Mail Facility','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1287, '','FACILITY','B','Branch','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1288, '','FACILITY','C','Community Post Office','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1289, '','FACILITY','D','Area Distribution Center','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1290, '','FACILITY','E','Sectional Center Facility','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1291, '','FACILITY','F','Delivery Distribution Center','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1292, '','FACILITY','G','General Mail Facility','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1293, '','FACILITY','K','Bulk Mail Facility','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1294, '','FACILITY','M','Money Order Unit','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1295, '','FACILITY','N','Community or place name','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1296, '','FACILITY','P','Post Office','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1297, '','FACILITY','S','Station','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1298, '','FACILITY','U','Urbanization (Used in Puerto Rico)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1299, '','FACILITY','X','Vanity name (Should not be used)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1300, '','GENDER','F','Female','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1301, '','GENDER','M','Male','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1302, '','GENDER','N','Neutral (Male or Female)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1303, '','GENDER','U','Unknown','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1304, '','LACS','L','Address requires LACS conversion','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Indicates that the address has undergone a LACS conversion.  Locatable Address Conversion Service (LACS) is a process where some rural route addresses are modified to city-style addresses to allow emergency services (i.e. ambulance, police, fire, etc.) to find these addresses more efficiently.  The new addresses are not contained within the ZIP+4 file.  To change the old addresses to the new addresses, you will need to send these addresses to a company that does LACS processing.','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1305, '','MSATYPE','MSA','Metropolitan Statistical Area','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1306, '','MSATYPE','PMSA','Primary Metropolitan Statistical Area','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1307, '','MSATYPE','CMSA','Consolidated Metropolitan Statistical Area','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1308, '','NAMESTATUS','V','Vulgar word found in full or first name','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1309, '','NAMESTATUS','X','Unable to parse name','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1310, '','PHONEERROR','A','Bad area code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Area code does not exist in the database or the area code contains characters)','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1311, '','PHONEERROR','B','Phone number is Blank','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1312, '','PHONEERROR','E','Bad Phone Number - too many or too few digits','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1313, '','PHONEERROR','M','Multiple Match for area codes','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Could not choose between 2 or more area codes as a bad or missing area code was encountered and the distance between the area codes was too close to choose one over the other','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1314, '','PHONEERROR','P','Bad Prefix','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','This prefix does not exist in the database','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1315, '','PHONEERROR','Z','Invalid ZIP Code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1316, '','PHONESTATUS','C','Corrected area code based on ZIP code it falls into','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1317, '','PHONESTATUS','D','Phone number is outside the demo range','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1318, '','PHONESTATUS','E','Expired database','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1319, '','PHONESTATUS','U','Updated area code due to area code split','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','The area code has split and the new area code is in the New_Phone_Area_Code Property. This area code was changed using area code/prefix data','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1320, '','PHONESTATUS','X','Bad phone number','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1321, 'US','STATE','*','No State','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1322, 'US','STATE','AA','Armed Forces Americas','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1323, 'US','STATE','AE','Armed Forces Afr/Can/Eur/Mid E','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1324, 'US','STATE','AK','Alaska','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1325, 'US','STATE','AL','Alabama','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1326, 'US','STATE','AP','Armed Forces Pacific','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1327, 'US','STATE','AR','Arkansas','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1328, 'US','STATE','AS','American Samoa','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1329, 'US','STATE','AZ','Arizona','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1330, 'US','STATE','CA','California','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1331, 'US','STATE','CO','Colorado','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1332, 'US','STATE','CT','Connecticut','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1333, 'US','STATE','DC','District Of Columbia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1334, 'US','STATE','DE','Delaware','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1335, 'US','STATE','FL','Florida','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1336, 'US','STATE','FM','Federated States Of Micronesia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1337, 'US','STATE','GA','Georgia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1338, 'US','STATE','GU','Guam','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1339, 'US','STATE','HI','Hawaii','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1340, 'US','STATE','IA','Iowa','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1341, 'US','STATE','ID','Idaho','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1342, 'US','STATE','IL','Illinois','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1343, 'US','STATE','IN','Indiana','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1344, 'US','STATE','KS','Kansas','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1345, 'US','STATE','KY','Kentucky','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1346, 'US','STATE','LA','Louisiana','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1347, 'US','STATE','MA','Massachusetts','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1348, 'US','STATE','MD','Maryland','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1349, 'US','STATE','ME','Maine','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1350, 'US','STATE','MH','Marshall Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1351, 'US','STATE','MI','Michigan','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1352, 'US','STATE','MN','Minnesota','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1353, 'US','STATE','MO','Missouri','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1354, 'US','STATE','MP','Northern Mariana Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1355, 'US','STATE','MS','Mississippi','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1356, 'US','STATE','MT','Montana','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1357, 'US','STATE','NC','North Carolina','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1358, 'US','STATE','ND','North Dakota','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1359, 'US','STATE','NE','Nebraska','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1360, 'US','STATE','NH','New Hampshire','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1361, 'US','STATE','NJ','New Jersey','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1362, 'US','STATE','NM','New Mexico','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1363, 'US','STATE','NV','Nevada','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1364, 'US','STATE','NY','New York','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1365, 'US','STATE','OH','Ohio','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1366, 'US','STATE','OK','Oklahoma','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1367, 'US','STATE','OR','Oregon','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1368, 'US','STATE','PA','Pennsylvania','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1369, 'US','STATE','PR','Puerto Rico','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1370, 'US','STATE','PW','Palau','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1371, 'US','STATE','RI','Rhode Island','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1372, 'US','STATE','SC','South Carolina','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1373, 'US','STATE','SD','South Dakota','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1374, 'US','STATE','TN','Tennessee','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1375, 'US','STATE','TX','Texas','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1376, 'US','STATE','UT','Utah','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1377, 'US','STATE','VA','Virginia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1378, 'US','STATE','VI','Virgin Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1379, 'US','STATE','VT','Vermont','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1380, 'US','STATE','WA','Washington','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1381, 'US','STATE','WI','Wisconsin','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1382, 'US','STATE','WV','West Virginia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1383, 'US','STATE','WY','Wyoming','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1384, 'CA','STATE','AB','Alberta','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1385, 'CA','STATE','BC','British Columbia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1386, 'CA','STATE','MB','Manitoba','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1387, 'CA','STATE','NB','New Brunswick','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1389, 'CA','STATE','NS','Nova Scotia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1390, 'CA','STATE','NT','Northwest Territories','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1391, 'CA','STATE','ON','Ontario','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1392, 'CA','STATE','PE','Prince Edward Island','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1393, 'CA','STATE','QC','Quebec','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',6,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1394, 'CA','STATE','SK','Saskatchewan','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1395, 'CA','STATE','YT','Yukon','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1396, 'US','STREETABBREV','ALLEE','ALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ALY','','','',''
insert into Cln_Lookups select 1397, 'US','STREETABBREV','ALLEY','ALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ALY','','','',''
insert into Cln_Lookups select 1398, 'US','STREETABBREV','ALLY','ALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ALY','','','',''
insert into Cln_Lookups select 1399, 'US','STREETABBREV','ALY','ALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ALY','','','',''
insert into Cln_Lookups select 1400, 'US','STREETABBREV','ANEX','ANNEX','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ANX','','','',''
insert into Cln_Lookups select 1401, 'US','STREETABBREV','ANNEX','ANNEX','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ANX','','','',''
insert into Cln_Lookups select 1402, 'US','STREETABBREV','ANNX','ANNEX','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ANX','','','',''
insert into Cln_Lookups select 1403, 'US','STREETABBREV','ANX','ANNEX','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ANX','','','',''
insert into Cln_Lookups select 1404, 'US','STREETABBREV','ARC','ARCADE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ARC','','','',''
insert into Cln_Lookups select 1405, 'US','STREETABBREV','ARCADE','ARCADE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ARC','','','',''
insert into Cln_Lookups select 1406, 'US','STREETABBREV','AV','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1407, 'US','STREETABBREV','AVE','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1408, 'US','STREETABBREV','AVEN','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1409, 'US','STREETABBREV','AVENU','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1410, 'US','STREETABBREV','AVENUE','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1411, 'US','STREETABBREV','AVN','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1412, 'US','STREETABBREV','AVNUE','AVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'AVE','','','',''
insert into Cln_Lookups select 1413, 'US','STREETABBREV','BAYOO','BAYOO','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYU','','','',''
insert into Cln_Lookups select 1414, 'US','STREETABBREV','BAYOU','BAYOO','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYU','','','',''
insert into Cln_Lookups select 1415, 'US','STREETABBREV','BCH','BEACH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BCH','','','',''
insert into Cln_Lookups select 1416, 'US','STREETABBREV','BEACH','BEACH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BCH','','','',''
insert into Cln_Lookups select 1417, 'US','STREETABBREV','BEND','BEND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BND','','','',''
insert into Cln_Lookups select 1418, 'US','STREETABBREV','BND','BEND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BND','','','',''
insert into Cln_Lookups select 1419, 'US','STREETABBREV','BLF','BLUFF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLF','','','',''
insert into Cln_Lookups select 1420, 'US','STREETABBREV','BLUF','BLUFF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLF','','','',''
insert into Cln_Lookups select 1421, 'US','STREETABBREV','BLUFF','BLUFF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLF','','','',''
insert into Cln_Lookups select 1422, 'US','STREETABBREV','BLUFFS','BLUFFS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLFS','','','',''
insert into Cln_Lookups select 1423, 'US','STREETABBREV','BOT','BOTTOM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BTM','','','',''
insert into Cln_Lookups select 1424, 'US','STREETABBREV','BOTTM','BOTTOM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BTM','','','',''
insert into Cln_Lookups select 1425, 'US','STREETABBREV','BOTTOM','BOTTOM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BTM','','','',''
insert into Cln_Lookups select 1426, 'US','STREETABBREV','BTM','BOTTOM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BTM','','','',''
insert into Cln_Lookups select 1427, 'US','STREETABBREV','BLVD','BOULEVARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLVD','','','',''
insert into Cln_Lookups select 1428, 'US','STREETABBREV','BOUL','BOULEVARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLVD','','','',''
insert into Cln_Lookups select 1429, 'US','STREETABBREV','BOULEVARD','BOULEVARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLVD','','','',''
insert into Cln_Lookups select 1430, 'US','STREETABBREV','BOULV','BOULEVARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLVD','','','',''
insert into Cln_Lookups select 1431, 'US','STREETABBREV','BR','BRANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BR','','','',''
insert into Cln_Lookups select 1432, 'US','STREETABBREV','BRANCH','BRANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BR','','','',''
insert into Cln_Lookups select 1433, 'US','STREETABBREV','BRNCH','BRANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BR','','','',''
insert into Cln_Lookups select 1434, 'US','STREETABBREV','BRDGE','BRIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRG','','','',''
insert into Cln_Lookups select 1435, 'US','STREETABBREV','BRG','BRIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRG','','','',''
insert into Cln_Lookups select 1436, 'US','STREETABBREV','BRIDGE','BRIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRG','','','',''
insert into Cln_Lookups select 1437, 'US','STREETABBREV','BRK','BROOK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRK','','','',''
insert into Cln_Lookups select 1438, 'US','STREETABBREV','BROOK','BROOK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRK','','','',''
insert into Cln_Lookups select 1439, 'US','STREETABBREV','BROOKS','BROOKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BRKS','','','',''
insert into Cln_Lookups select 1440, 'US','STREETABBREV','BURG','BURG','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BG','','','',''
insert into Cln_Lookups select 1441, 'US','STREETABBREV','BURGS','BURGS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BGS','','','',''
insert into Cln_Lookups select 1442, 'US','STREETABBREV','BYP','BYPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYP','','','',''
insert into Cln_Lookups select 1443, 'US','STREETABBREV','BYPA','BYPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYP','','','',''
insert into Cln_Lookups select 1444, 'US','STREETABBREV','BYPAS','BYPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYP','','','',''
insert into Cln_Lookups select 1445, 'US','STREETABBREV','BYPASS','BYPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYP','','','',''
insert into Cln_Lookups select 1446, 'US','STREETABBREV','BYPS','BYPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BYP','','','',''
insert into Cln_Lookups select 1447, 'US','STREETABBREV','CAMP','CAMP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CP','','','',''
insert into Cln_Lookups select 1448, 'US','STREETABBREV','CMP','CAMP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CP','','','',''
insert into Cln_Lookups select 1449, 'US','STREETABBREV','CP','CAMP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CP','','','',''
insert into Cln_Lookups select 1450, 'US','STREETABBREV','CANYN','CANYON','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CYN','','','',''
insert into Cln_Lookups select 1451, 'US','STREETABBREV','CANYON','CANYON','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CYN','','','',''
insert into Cln_Lookups select 1452, 'US','STREETABBREV','CNYN','CANYON','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CYN','','','',''
insert into Cln_Lookups select 1453, 'US','STREETABBREV','CYN','CANYON','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CYN','','','',''
insert into Cln_Lookups select 1454, 'US','STREETABBREV','CAPE','CAPE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CPE','','','',''
insert into Cln_Lookups select 1455, 'US','STREETABBREV','CPE','CAPE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CPE','','','',''
insert into Cln_Lookups select 1456, 'US','STREETABBREV','CAUSEWAY','CAUSEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CSWY','','','',''
insert into Cln_Lookups select 1457, 'US','STREETABBREV','CAUSWAY','CAUSEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CSWY','','','',''
insert into Cln_Lookups select 1458, 'US','STREETABBREV','CSWY','CAUSEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CSWY','','','',''
insert into Cln_Lookups select 1459, 'US','STREETABBREV','CEN','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1460, 'US','STREETABBREV','CENT','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1461, 'US','STREETABBREV','CENTER','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1462, 'US','STREETABBREV','CENTR','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1463, 'US','STREETABBREV','CENTRE','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1464, 'US','STREETABBREV','CNTER','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1465, 'US','STREETABBREV','CNTR','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1466, 'US','STREETABBREV','CTR','CENTER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTR','','','',''
insert into Cln_Lookups select 1467, 'US','STREETABBREV','CENTERS','CENTERS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTRS','','','',''
insert into Cln_Lookups select 1468, 'US','STREETABBREV','CIR','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1469, 'US','STREETABBREV','CIRC','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1470, 'US','STREETABBREV','CIRCL','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1471, 'US','STREETABBREV','CIRCLE','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1472, 'US','STREETABBREV','CRCL','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1473, 'US','STREETABBREV','CRCLE','CIRCLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIR','','','',''
insert into Cln_Lookups select 1474, 'US','STREETABBREV','CIRCLES','CIRCLES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CIRS','','','',''
insert into Cln_Lookups select 1475, 'US','STREETABBREV','CLF','CLIFF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLF','','','',''
insert into Cln_Lookups select 1476, 'US','STREETABBREV','CLIFF','CLIFF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLF','','','',''
insert into Cln_Lookups select 1477, 'US','STREETABBREV','CLFS','CLIFFS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLFS','','','',''
insert into Cln_Lookups select 1478, 'US','STREETABBREV','CLIFFS','CLIFFS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLFS','','','',''
insert into Cln_Lookups select 1479, 'US','STREETABBREV','CLB','CLUB','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLB','','','',''
insert into Cln_Lookups select 1480, 'US','STREETABBREV','CLUB','CLUB','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CLB','','','',''
insert into Cln_Lookups select 1481, 'US','STREETABBREV','COMMON','COMMON','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CMN','','','',''
insert into Cln_Lookups select 1482, 'US','STREETABBREV','COR','CORNER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'COR','','','',''
insert into Cln_Lookups select 1483, 'US','STREETABBREV','CORNER','CORNER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'COR','','','',''
insert into Cln_Lookups select 1484, 'US','STREETABBREV','CORNERS','CORNERS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CORS','','','',''
insert into Cln_Lookups select 1485, 'US','STREETABBREV','CORS','CORNERS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CORS','','','',''
insert into Cln_Lookups select 1486, 'US','STREETABBREV','COURSE','COURSE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRSE','','','',''
insert into Cln_Lookups select 1487, 'US','STREETABBREV','CRSE','COURSE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRSE','','','',''
insert into Cln_Lookups select 1488, 'US','STREETABBREV','COURT','COURT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CT','','','',''
insert into Cln_Lookups select 1489, 'US','STREETABBREV','CRT','COURT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CT','','','',''
insert into Cln_Lookups select 1490, 'US','STREETABBREV','CT','COURT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CT','','','',''
insert into Cln_Lookups select 1491, 'US','STREETABBREV','COURTS','COURTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTS','','','',''
insert into Cln_Lookups select 1492, 'US','STREETABBREV','CTS','COURTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CTS','','','',''
insert into Cln_Lookups select 1493, 'US','STREETABBREV','COVE','COVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CV','','','',''
insert into Cln_Lookups select 1494, 'US','STREETABBREV','CV','COVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CV','','','',''
insert into Cln_Lookups select 1495, 'US','STREETABBREV','COVES','COVES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CVS','','','',''
insert into Cln_Lookups select 1496, 'US','STREETABBREV','CK','CREEK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRK','','','',''
insert into Cln_Lookups select 1497, 'US','STREETABBREV','CR','CREEK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRK','','','',''
insert into Cln_Lookups select 1498, 'US','STREETABBREV','CREEK','CREEK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRK','','','',''
insert into Cln_Lookups select 1499, 'US','STREETABBREV','CRK','CREEK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRK','','','',''
insert into Cln_Lookups select 1500, 'US','STREETABBREV','CRECENT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1501, 'US','STREETABBREV','CRES','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1502, 'US','STREETABBREV','CRESCENT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1503, 'US','STREETABBREV','CRESENT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1504, 'US','STREETABBREV','CRSCNT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1505, 'US','STREETABBREV','CRSENT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1506, 'US','STREETABBREV','CRSNT','CRESCENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRES','','','',''
insert into Cln_Lookups select 1507, 'US','STREETABBREV','CREST','CREST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CRST','','','',''
insert into Cln_Lookups select 1508, 'US','STREETABBREV','CROSSING','CROSSING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'XING','','','',''
insert into Cln_Lookups select 1509, 'US','STREETABBREV','CRSSING','CROSSING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'XING','','','',''
insert into Cln_Lookups select 1510, 'US','STREETABBREV','CRSSNG','CROSSING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'XING','','','',''
insert into Cln_Lookups select 1511, 'US','STREETABBREV','XING','CROSSING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'XING','','','',''
insert into Cln_Lookups select 1512, 'US','STREETABBREV','CROSSROAD','CROSSROAD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'XRD','','','',''
insert into Cln_Lookups select 1513, 'US','STREETABBREV','CURVE','CURVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'CURV','','','',''
insert into Cln_Lookups select 1514, 'US','STREETABBREV','DALE','DALE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DL','','','',''
insert into Cln_Lookups select 1515, 'US','STREETABBREV','DL','DALE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DL','','','',''
insert into Cln_Lookups select 1516, 'US','STREETABBREV','DAM','DAM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DM','','','',''
insert into Cln_Lookups select 1517, 'US','STREETABBREV','DM','DAM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DM','','','',''
insert into Cln_Lookups select 1518, 'US','STREETABBREV','DIV','DIVIDE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DV','','','',''
insert into Cln_Lookups select 1519, 'US','STREETABBREV','DIVIDE','DIVIDE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DV','','','',''
insert into Cln_Lookups select 1520, 'US','STREETABBREV','DV','DIVIDE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DV','','','',''
insert into Cln_Lookups select 1521, 'US','STREETABBREV','DVD','DIVIDE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DV','','','',''
insert into Cln_Lookups select 1522, 'US','STREETABBREV','DR','DRIVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DR','','','',''
insert into Cln_Lookups select 1523, 'US','STREETABBREV','DRIV','DRIVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DR','','','',''
insert into Cln_Lookups select 1524, 'US','STREETABBREV','DRIVE','DRIVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DR','','','',''
insert into Cln_Lookups select 1525, 'US','STREETABBREV','DRV','DRIVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DR','','','',''
insert into Cln_Lookups select 1526, 'US','STREETABBREV','DRIVES','DRIVES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DRS','','','',''
insert into Cln_Lookups select 1527, 'US','STREETABBREV','EST','ESTATE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EST','','','',''
insert into Cln_Lookups select 1528, 'US','STREETABBREV','ESTATE','ESTATE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EST','','','',''
insert into Cln_Lookups select 1529, 'US','STREETABBREV','ESTATES','ESTATES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ESTS','','','',''
insert into Cln_Lookups select 1530, 'US','STREETABBREV','ESTS','ESTATES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ESTS','','','',''
insert into Cln_Lookups select 1531, 'US','STREETABBREV','EXP','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1532, 'US','STREETABBREV','EXPR','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1533, 'US','STREETABBREV','EXPRESS','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1534, 'US','STREETABBREV','EXPRESSWAY','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1535, 'US','STREETABBREV','EXPW','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1536, 'US','STREETABBREV','EXPY','EXPRESSWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXPY','','','',''
insert into Cln_Lookups select 1537, 'US','STREETABBREV','EXT','EXTENSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXT','','','',''
insert into Cln_Lookups select 1538, 'US','STREETABBREV','EXTENSION','EXTENSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXT','','','',''
insert into Cln_Lookups select 1539, 'US','STREETABBREV','EXTN','EXTENSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXT','','','',''
insert into Cln_Lookups select 1540, 'US','STREETABBREV','EXTNSN','EXTENSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXT','','','',''
insert into Cln_Lookups select 1541, 'US','STREETABBREV','EXTENSIONS','EXTENSIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXTS','','','',''
insert into Cln_Lookups select 1542, 'US','STREETABBREV','EXTS','EXTENSIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'EXTS','','','',''
insert into Cln_Lookups select 1543, 'US','STREETABBREV','FALL','FALL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FALL','','','',''
insert into Cln_Lookups select 1544, 'US','STREETABBREV','FALLS','FALLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLS','','','',''
insert into Cln_Lookups select 1545, 'US','STREETABBREV','FLS','FALLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLS','','','',''
insert into Cln_Lookups select 1546, 'US','STREETABBREV','FERRY','FERRY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRY','','','',''
insert into Cln_Lookups select 1547, 'US','STREETABBREV','FRRY','FERRY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRY','','','',''
insert into Cln_Lookups select 1548, 'US','STREETABBREV','FRY','FERRY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRY','','','',''
insert into Cln_Lookups select 1549, 'US','STREETABBREV','FIELD','FIELD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLD','','','',''
insert into Cln_Lookups select 1550, 'US','STREETABBREV','FLD','FIELD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLD','','','',''
insert into Cln_Lookups select 1551, 'US','STREETABBREV','FIELDS','FIELDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLDS','','','',''
insert into Cln_Lookups select 1552, 'US','STREETABBREV','FLDS','FIELDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLDS','','','',''
insert into Cln_Lookups select 1553, 'US','STREETABBREV','FLAT','FLAT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLT','','','',''
insert into Cln_Lookups select 1554, 'US','STREETABBREV','FLT','FLAT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLT','','','',''
insert into Cln_Lookups select 1555, 'US','STREETABBREV','FLATS','FLATS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLTS','','','',''
insert into Cln_Lookups select 1556, 'US','STREETABBREV','FLTS','FLATS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FLTS','','','',''
insert into Cln_Lookups select 1557, 'US','STREETABBREV','FORD','FORD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRD','','','',''
insert into Cln_Lookups select 1558, 'US','STREETABBREV','FRD','FORD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRD','','','',''
insert into Cln_Lookups select 1559, 'US','STREETABBREV','FORDS','FORDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRDS','','','',''
insert into Cln_Lookups select 1560, 'US','STREETABBREV','FOREST','FOREST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRST','','','',''
insert into Cln_Lookups select 1561, 'US','STREETABBREV','FORESTS','FOREST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRST','','','',''
insert into Cln_Lookups select 1562, 'US','STREETABBREV','FRST','FOREST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRST','','','',''
insert into Cln_Lookups select 1563, 'US','STREETABBREV','FORG','FORGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRG','','','',''
insert into Cln_Lookups select 1564, 'US','STREETABBREV','FORGE','FORGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRG','','','',''
insert into Cln_Lookups select 1565, 'US','STREETABBREV','FRG','FORGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRG','','','',''
insert into Cln_Lookups select 1566, 'US','STREETABBREV','FORGES','FORGES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRGS','','','',''
insert into Cln_Lookups select 1567, 'US','STREETABBREV','FORK','FORK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRK','','','',''
insert into Cln_Lookups select 1568, 'US','STREETABBREV','FRK','FORK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRK','','','',''
insert into Cln_Lookups select 1569, 'US','STREETABBREV','FORKS','FORKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRKS','','','',''
insert into Cln_Lookups select 1570, 'US','STREETABBREV','FRKS','FORKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRKS','','','',''
insert into Cln_Lookups select 1571, 'US','STREETABBREV','FORT','FORT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FT','','','',''
insert into Cln_Lookups select 1572, 'US','STREETABBREV','FRT','FORT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FT','','','',''
insert into Cln_Lookups select 1573, 'US','STREETABBREV','FT','FORT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FT','','','',''
insert into Cln_Lookups select 1574, 'US','STREETABBREV','FREEWAY','FREEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FWY','','','',''
insert into Cln_Lookups select 1575, 'US','STREETABBREV','FREEWY','FREEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FWY','','','',''
insert into Cln_Lookups select 1576, 'US','STREETABBREV','FRWAY','FREEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FWY','','','',''
insert into Cln_Lookups select 1577, 'US','STREETABBREV','FRWY','FREEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FWY','','','',''
insert into Cln_Lookups select 1578, 'US','STREETABBREV','FWY','FREEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FWY','','','',''
insert into Cln_Lookups select 1579, 'US','STREETABBREV','GARDEN','GARDEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDN','','','',''
insert into Cln_Lookups select 1580, 'US','STREETABBREV','GARDN','GARDEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDN','','','',''
insert into Cln_Lookups select 1581, 'US','STREETABBREV','GDN','GARDEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDN','','','',''
insert into Cln_Lookups select 1582, 'US','STREETABBREV','GRDEN','GARDEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDN','','','',''
insert into Cln_Lookups select 1583, 'US','STREETABBREV','GRDN','GARDEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDN','','','',''
insert into Cln_Lookups select 1584, 'US','STREETABBREV','GARDENS','GARDENS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDNS','','','',''
insert into Cln_Lookups select 1585, 'US','STREETABBREV','GDNS','GARDENS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDNS','','','',''
insert into Cln_Lookups select 1586, 'US','STREETABBREV','GRDNS','GARDENS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GDNS','','','',''
insert into Cln_Lookups select 1587, 'US','STREETABBREV','GATEWAY','GATEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GTWY','','','',''
insert into Cln_Lookups select 1588, 'US','STREETABBREV','GATEWY','GATEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GTWY','','','',''
insert into Cln_Lookups select 1589, 'US','STREETABBREV','GATWAY','GATEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GTWY','','','',''
insert into Cln_Lookups select 1590, 'US','STREETABBREV','GTWAY','GATEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GTWY','','','',''
insert into Cln_Lookups select 1591, 'US','STREETABBREV','GTWY','GATEWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GTWY','','','',''
insert into Cln_Lookups select 1592, 'US','STREETABBREV','GLEN','GLEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GLN','','','',''
insert into Cln_Lookups select 1593, 'US','STREETABBREV','GLN','GLEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GLN','','','',''
insert into Cln_Lookups select 1594, 'US','STREETABBREV','GLENS','GLENS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GLNS','','','',''
insert into Cln_Lookups select 1595, 'US','STREETABBREV','GREEN','GREEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRN','','','',''
insert into Cln_Lookups select 1596, 'US','STREETABBREV','GRN','GREEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRN','','','',''
insert into Cln_Lookups select 1597, 'US','STREETABBREV','GREENS','GREENS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRNS','','','',''
insert into Cln_Lookups select 1598, 'US','STREETABBREV','GROV','GROVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRV','','','',''
insert into Cln_Lookups select 1599, 'US','STREETABBREV','GROVE','GROVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRV','','','',''
insert into Cln_Lookups select 1600, 'US','STREETABBREV','GRV','GROVE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRV','','','',''
insert into Cln_Lookups select 1601, 'US','STREETABBREV','GROVES','GROVES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'GRVS','','','',''
insert into Cln_Lookups select 1602, 'US','STREETABBREV','HARB','HARBOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBR','','','',''
insert into Cln_Lookups select 1603, 'US','STREETABBREV','HARBOR','HARBOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBR','','','',''
insert into Cln_Lookups select 1604, 'US','STREETABBREV','HARBR','HARBOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBR','','','',''
insert into Cln_Lookups select 1605, 'US','STREETABBREV','HBR','HARBOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBR','','','',''
insert into Cln_Lookups select 1606, 'US','STREETABBREV','HRBOR','HARBOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBR','','','',''
insert into Cln_Lookups select 1607, 'US','STREETABBREV','HARBORS','HARBORS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HBRS','','','',''
insert into Cln_Lookups select 1608, 'US','STREETABBREV','HAVEN','HAVEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HVN','','','',''
insert into Cln_Lookups select 1609, 'US','STREETABBREV','HAVN','HAVEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HVN','','','',''
insert into Cln_Lookups select 1610, 'US','STREETABBREV','HVN','HAVEN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HVN','','','',''
insert into Cln_Lookups select 1611, 'US','STREETABBREV','HEIGHT','HEIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HTS','','','',''
insert into Cln_Lookups select 1612, 'US','STREETABBREV','HEIGHTS','HEIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HTS','','','',''
insert into Cln_Lookups select 1613, 'US','STREETABBREV','HGTS','HEIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HTS','','','',''
insert into Cln_Lookups select 1614, 'US','STREETABBREV','HT','HEIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HTS','','','',''
insert into Cln_Lookups select 1615, 'US','STREETABBREV','HTS','HEIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HTS','','','',''
insert into Cln_Lookups select 1616, 'US','STREETABBREV','HIGHWAY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1617, 'US','STREETABBREV','HIGHWY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1618, 'US','STREETABBREV','HIWAY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1619, 'US','STREETABBREV','HIWY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1620, 'US','STREETABBREV','HWAY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1621, 'US','STREETABBREV','HWY','HIGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HWY','','','',''
insert into Cln_Lookups select 1622, 'US','STREETABBREV','HILL','HILL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HL','','','',''
insert into Cln_Lookups select 1623, 'US','STREETABBREV','HL','HILL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HL','','','',''
insert into Cln_Lookups select 1624, 'US','STREETABBREV','HILLS','HILLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HLS','','','',''
insert into Cln_Lookups select 1625, 'US','STREETABBREV','HLS','HILLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HLS','','','',''
insert into Cln_Lookups select 1626, 'US','STREETABBREV','HLLW','HOLLOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HOLW','','','',''
insert into Cln_Lookups select 1627, 'US','STREETABBREV','HOLLOW','HOLLOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HOLW','','','',''
insert into Cln_Lookups select 1628, 'US','STREETABBREV','HOLLOWS','HOLLOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HOLW','','','',''
insert into Cln_Lookups select 1629, 'US','STREETABBREV','HOLW','HOLLOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HOLW','','','',''
insert into Cln_Lookups select 1630, 'US','STREETABBREV','HOLWS','HOLLOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HOLW','','','',''
insert into Cln_Lookups select 1631, 'US','STREETABBREV','INLET','INLET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'INLT','','','',''
insert into Cln_Lookups select 1632, 'US','STREETABBREV','INLT','INLET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'INLT','','','',''
insert into Cln_Lookups select 1633, 'US','STREETABBREV','IS','ISLAND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'IS','','','',''
insert into Cln_Lookups select 1634, 'US','STREETABBREV','ISLAND','ISLAND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'IS','','','',''
insert into Cln_Lookups select 1635, 'US','STREETABBREV','ISLND','ISLAND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'IS','','','',''
insert into Cln_Lookups select 1636, 'US','STREETABBREV','ISLANDS','ISLANDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ISS','','','',''
insert into Cln_Lookups select 1637, 'US','STREETABBREV','ISLNDS','ISLANDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ISS','','','',''
insert into Cln_Lookups select 1638, 'US','STREETABBREV','ISS','ISLANDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ISS','','','',''
insert into Cln_Lookups select 1639, 'US','STREETABBREV','ISLE','ISLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ISLE','','','',''
insert into Cln_Lookups select 1640, 'US','STREETABBREV','ISLES','ISLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ISLE','','','',''
insert into Cln_Lookups select 1641, 'US','STREETABBREV','JCT','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1642, 'US','STREETABBREV','JCTION','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1643, 'US','STREETABBREV','JCTN','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1644, 'US','STREETABBREV','JUNCTION','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1645, 'US','STREETABBREV','JUNCTN','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1646, 'US','STREETABBREV','JUNCTON','JUNCTION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCT','','','',''
insert into Cln_Lookups select 1647, 'US','STREETABBREV','JCTNS','JUNCTIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCTS','','','',''
insert into Cln_Lookups select 1648, 'US','STREETABBREV','JCTS','JUNCTIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCTS','','','',''
insert into Cln_Lookups select 1649, 'US','STREETABBREV','JUNCTIONS','JUNCTIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'JCTS','','','',''
insert into Cln_Lookups select 1650, 'US','STREETABBREV','KEY','KEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KY','','','',''
insert into Cln_Lookups select 1651, 'US','STREETABBREV','KY','KEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KY','','','',''
insert into Cln_Lookups select 1652, 'US','STREETABBREV','KEYS','KEYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KYS','','','',''
insert into Cln_Lookups select 1653, 'US','STREETABBREV','KYS','KEYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KYS','','','',''
insert into Cln_Lookups select 1654, 'US','STREETABBREV','KNL','KNOLL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KNL','','','',''
insert into Cln_Lookups select 1655, 'US','STREETABBREV','KNOL','KNOLL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KNL','','','',''
insert into Cln_Lookups select 1656, 'US','STREETABBREV','KNOLL','KNOLL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KNL','','','',''
insert into Cln_Lookups select 1657, 'US','STREETABBREV','KNLS','KNOLLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KNLS','','','',''
insert into Cln_Lookups select 1658, 'US','STREETABBREV','KNOLLS','KNOLLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'KNLS','','','',''
insert into Cln_Lookups select 1659, 'US','STREETABBREV','LAKE','LAKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LK','','','',''
insert into Cln_Lookups select 1660, 'US','STREETABBREV','LK','LAKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LK','','','',''
insert into Cln_Lookups select 1661, 'US','STREETABBREV','LAKES','LAKES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LKS','','','',''
insert into Cln_Lookups select 1662, 'US','STREETABBREV','LKS','LAKES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LKS','','','',''
insert into Cln_Lookups select 1663, 'US','STREETABBREV','LAND','LAND','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LAND','','','',''
insert into Cln_Lookups select 1664, 'US','STREETABBREV','LANDING','LANDING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LNDG','','','',''
insert into Cln_Lookups select 1665, 'US','STREETABBREV','LNDG','LANDING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LNDG','','','',''
insert into Cln_Lookups select 1666, 'US','STREETABBREV','LNDNG','LANDING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LNDG','','','',''
insert into Cln_Lookups select 1667, 'US','STREETABBREV','LA','LANE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LN','','','',''
insert into Cln_Lookups select 1668, 'US','STREETABBREV','LANE','LANE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LN','','','',''
insert into Cln_Lookups select 1669, 'US','STREETABBREV','LANES','LANE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LN','','','',''
insert into Cln_Lookups select 1670, 'US','STREETABBREV','LN','LANE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LN','','','',''
insert into Cln_Lookups select 1671, 'US','STREETABBREV','LGT','LIGHT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LGT','','','',''
insert into Cln_Lookups select 1672, 'US','STREETABBREV','LIGHT','LIGHT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LGT','','','',''
insert into Cln_Lookups select 1673, 'US','STREETABBREV','LIGHTS','LIGHTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LGTS','','','',''
insert into Cln_Lookups select 1674, 'US','STREETABBREV','LF','LOAF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LF','','','',''
insert into Cln_Lookups select 1675, 'US','STREETABBREV','LOAF','LOAF','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LF','','','',''
insert into Cln_Lookups select 1676, 'US','STREETABBREV','LCK','LOCK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LCK','','','',''
insert into Cln_Lookups select 1677, 'US','STREETABBREV','LOCK','LOCK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LCK','','','',''
insert into Cln_Lookups select 1678, 'US','STREETABBREV','LCKS','LOCKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LCKS','','','',''
insert into Cln_Lookups select 1679, 'US','STREETABBREV','LOCKS','LOCKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LCKS','','','',''
insert into Cln_Lookups select 1680, 'US','STREETABBREV','LDG','LODGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LDG','','','',''
insert into Cln_Lookups select 1681, 'US','STREETABBREV','LDGE','LODGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LDG','','','',''
insert into Cln_Lookups select 1682, 'US','STREETABBREV','LODG','LODGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LDG','','','',''
insert into Cln_Lookups select 1683, 'US','STREETABBREV','LODGE','LODGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LDG','','','',''
insert into Cln_Lookups select 1684, 'US','STREETABBREV','LOOP','LOOP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LOOP','','','',''
insert into Cln_Lookups select 1685, 'US','STREETABBREV','LOOPS','LOOP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LOOP','','','',''
insert into Cln_Lookups select 1686, 'US','STREETABBREV','MALL','MALL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MALL','','','',''
insert into Cln_Lookups select 1687, 'US','STREETABBREV','MANOR','MANOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MNR','','','',''
insert into Cln_Lookups select 1688, 'US','STREETABBREV','MNR','MANOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MNR','','','',''
insert into Cln_Lookups select 1689, 'US','STREETABBREV','MANORS','MANORS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MNRS','','','',''
insert into Cln_Lookups select 1690, 'US','STREETABBREV','MNRS','MANORS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MNRS','','','',''
insert into Cln_Lookups select 1691, 'US','STREETABBREV','MDW','MEADOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MDW','','','',''
insert into Cln_Lookups select 1692, 'US','STREETABBREV','MEADOW','MEADOW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MDW','','','',''
insert into Cln_Lookups select 1693, 'US','STREETABBREV','MDWS','MEADOWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MDWS','','','',''
insert into Cln_Lookups select 1694, 'US','STREETABBREV','MEADOWS','MEADOWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MDWS','','','',''
insert into Cln_Lookups select 1695, 'US','STREETABBREV','MEDOWS','MEADOWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MDWS','','','',''
insert into Cln_Lookups select 1696, 'US','STREETABBREV','MEWS','MEWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MEWS','','','',''
insert into Cln_Lookups select 1697, 'US','STREETABBREV','MILL','MILL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ML','','','',''
insert into Cln_Lookups select 1698, 'US','STREETABBREV','ML','MILL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ML','','','',''
insert into Cln_Lookups select 1699, 'US','STREETABBREV','MILLS','MILLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MLS','','','',''
insert into Cln_Lookups select 1700, 'US','STREETABBREV','MLS','MILLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MLS','','','',''
insert into Cln_Lookups select 1701, 'US','STREETABBREV','MISSION','MISSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MSN','','','',''
insert into Cln_Lookups select 1702, 'US','STREETABBREV','MISSN','MISSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MSN','','','',''
insert into Cln_Lookups select 1703, 'US','STREETABBREV','MSN','MISSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MSN','','','',''
insert into Cln_Lookups select 1704, 'US','STREETABBREV','MSSN','MISSION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MSN','','','',''
insert into Cln_Lookups select 1705, 'US','STREETABBREV','MOTORWAY','MOTORWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTWY','','','',''
insert into Cln_Lookups select 1706, 'US','STREETABBREV','MNT','MOUNT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MT','','','',''
insert into Cln_Lookups select 1707, 'US','STREETABBREV','MOUNT','MOUNT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MT','','','',''
insert into Cln_Lookups select 1708, 'US','STREETABBREV','MT','MOUNT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MT','','','',''
insert into Cln_Lookups select 1709, 'US','STREETABBREV','MNTAIN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1710, 'US','STREETABBREV','MNTN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1711, 'US','STREETABBREV','MOUNTAIN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1712, 'US','STREETABBREV','MOUNTIN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1713, 'US','STREETABBREV','MTIN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1714, 'US','STREETABBREV','MTN','MOUNTAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTN','','','',''
insert into Cln_Lookups select 1715, 'US','STREETABBREV','MNTNS','MOUNTAINS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTNS','','','',''
insert into Cln_Lookups select 1716, 'US','STREETABBREV','MOUNTAINS','MOUNTAINS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'MTNS','','','',''
insert into Cln_Lookups select 1717, 'US','STREETABBREV','NCK','NECK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'NCK','','','',''
insert into Cln_Lookups select 1718, 'US','STREETABBREV','NECK','NECK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'NCK','','','',''
insert into Cln_Lookups select 1719, 'US','STREETABBREV','ORCH','ORCHARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ORCH','','','',''
insert into Cln_Lookups select 1720, 'US','STREETABBREV','ORCHARD','ORCHARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ORCH','','','',''
insert into Cln_Lookups select 1721, 'US','STREETABBREV','ORCHRD','ORCHARD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ORCH','','','',''
insert into Cln_Lookups select 1722, 'US','STREETABBREV','OVAL','OVAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'OVAL','','','',''
insert into Cln_Lookups select 1723, 'US','STREETABBREV','OVL','OVAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'OVAL','','','',''
insert into Cln_Lookups select 1724, 'US','STREETABBREV','OVERPASS','OVERPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'OPAS','','','',''
insert into Cln_Lookups select 1725, 'US','STREETABBREV','PARK','PARK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PARK','','','',''
insert into Cln_Lookups select 1726, 'US','STREETABBREV','PK','PARK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PARK','','','',''
insert into Cln_Lookups select 1727, 'US','STREETABBREV','PRK','PARK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PARK','','','',''
insert into Cln_Lookups select 1728, 'US','STREETABBREV','PARKS','PARKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PARK','','','',''
insert into Cln_Lookups select 1729, 'US','STREETABBREV','PARKWAY','PARKWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1730, 'US','STREETABBREV','PARKWY','PARKWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1731, 'US','STREETABBREV','PKWAY','PARKWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1732, 'US','STREETABBREV','PKWY','PARKWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1733, 'US','STREETABBREV','PKY','PARKWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1734, 'US','STREETABBREV','PARKWAYS','PARKWAYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1735, 'US','STREETABBREV','PKWYS','PARKWAYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PKWY','','','',''
insert into Cln_Lookups select 1736, 'US','STREETABBREV','PASS','PASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PASS','','','',''
insert into Cln_Lookups select 1737, 'US','STREETABBREV','PASSAGE','PASSAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PSGE','','','',''
insert into Cln_Lookups select 1738, 'US','STREETABBREV','PATH','PATH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PATH','','','',''
insert into Cln_Lookups select 1739, 'US','STREETABBREV','PATHS','PATH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PATH','','','',''
insert into Cln_Lookups select 1740, 'US','STREETABBREV','PIKE','PIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PIKE','','','',''
insert into Cln_Lookups select 1741, 'US','STREETABBREV','PIKES','PIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PIKE','','','',''
insert into Cln_Lookups select 1742, 'US','STREETABBREV','PINE','PINE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PNE','','','',''
insert into Cln_Lookups select 1743, 'US','STREETABBREV','PINES','PINES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PNES','','','',''
insert into Cln_Lookups select 1744, 'US','STREETABBREV','PNES','PINES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PNES','','','',''
insert into Cln_Lookups select 1745, 'US','STREETABBREV','PL','PLACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PL','','','',''
insert into Cln_Lookups select 1746, 'US','STREETABBREV','PLACE','PLACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PL','','','',''
insert into Cln_Lookups select 1747, 'US','STREETABBREV','PLAIN','PLAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLN','','','',''
insert into Cln_Lookups select 1748, 'US','STREETABBREV','PLN','PLAIN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLN','','','',''
insert into Cln_Lookups select 1749, 'US','STREETABBREV','PLAINES','PLAINS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLNS','','','',''
insert into Cln_Lookups select 1750, 'US','STREETABBREV','PLAINS','PLAINS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLNS','','','',''
insert into Cln_Lookups select 1751, 'US','STREETABBREV','PLNS','PLAINS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLNS','','','',''
insert into Cln_Lookups select 1752, 'US','STREETABBREV','PLAZA','PLAZA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLZ','','','',''
insert into Cln_Lookups select 1753, 'US','STREETABBREV','PLZ','PLAZA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLZ','','','',''
insert into Cln_Lookups select 1754, 'US','STREETABBREV','PLZA','PLAZA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PLZ','','','',''
insert into Cln_Lookups select 1755, 'US','STREETABBREV','POINT','POINT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PT','','','',''
insert into Cln_Lookups select 1756, 'US','STREETABBREV','PT','POINT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PT','','','',''
insert into Cln_Lookups select 1757, 'US','STREETABBREV','POINTS','POINTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PTS','','','',''
insert into Cln_Lookups select 1758, 'US','STREETABBREV','PTS','POINTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PTS','','','',''
insert into Cln_Lookups select 1759, 'US','STREETABBREV','PORT','PORT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PRT','','','',''
insert into Cln_Lookups select 1760, 'US','STREETABBREV','PRT','PORT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PRT','','','',''
insert into Cln_Lookups select 1761, 'US','STREETABBREV','PORTS','PORTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PRTS','','','',''
insert into Cln_Lookups select 1762, 'US','STREETABBREV','PRTS','PORTS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PRTS','','','',''
insert into Cln_Lookups select 1763, 'US','STREETABBREV','PR','PRAIRIE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PR','','','',''
insert into Cln_Lookups select 1764, 'US','STREETABBREV','PRAIRIE','PRAIRIE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PR','','','',''
insert into Cln_Lookups select 1765, 'US','STREETABBREV','PRARIE','PRAIRIE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PR','','','',''
insert into Cln_Lookups select 1766, 'US','STREETABBREV','PRR','PRAIRIE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PR','','','',''
insert into Cln_Lookups select 1767, 'US','STREETABBREV','RAD','RADIAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RADL','','','',''
insert into Cln_Lookups select 1768, 'US','STREETABBREV','RADIAL','RADIAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RADL','','','',''
insert into Cln_Lookups select 1769, 'US','STREETABBREV','RADIEL','RADIAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RADL','','','',''
insert into Cln_Lookups select 1770, 'US','STREETABBREV','RADL','RADIAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RADL','','','',''
insert into Cln_Lookups select 1771, 'US','STREETABBREV','RAMP','RAMP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RAMP','','','',''
insert into Cln_Lookups select 1772, 'US','STREETABBREV','RANCH','RANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RNCH','','','',''
insert into Cln_Lookups select 1773, 'US','STREETABBREV','RANCHES','RANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RNCH','','','',''
insert into Cln_Lookups select 1774, 'US','STREETABBREV','RNCH','RANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RNCH','','','',''
insert into Cln_Lookups select 1775, 'US','STREETABBREV','RNCHS','RANCH','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RNCH','','','',''
insert into Cln_Lookups select 1776, 'US','STREETABBREV','RAPID','RAPID','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RPD','','','',''
insert into Cln_Lookups select 1777, 'US','STREETABBREV','RPD','RAPID','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RPD','','','',''
insert into Cln_Lookups select 1778, 'US','STREETABBREV','RAPIDS','RAPIDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RPDS','','','',''
insert into Cln_Lookups select 1779, 'US','STREETABBREV','RPDS','RAPIDS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RPDS','','','',''
insert into Cln_Lookups select 1780, 'US','STREETABBREV','REST','REST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RST','','','',''
insert into Cln_Lookups select 1781, 'US','STREETABBREV','RST','REST','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RST','','','',''
insert into Cln_Lookups select 1782, 'US','STREETABBREV','RDG','RIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDG','','','',''
insert into Cln_Lookups select 1783, 'US','STREETABBREV','RDGE','RIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDG','','','',''
insert into Cln_Lookups select 1784, 'US','STREETABBREV','RIDGE','RIDGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDG','','','',''
insert into Cln_Lookups select 1785, 'US','STREETABBREV','RDGS','RIDGES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDGS','','','',''
insert into Cln_Lookups select 1786, 'US','STREETABBREV','RIDGES','RIDGES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDGS','','','',''
insert into Cln_Lookups select 1787, 'US','STREETABBREV','RIV','RIVER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RIV','','','',''
insert into Cln_Lookups select 1788, 'US','STREETABBREV','RIVER','RIVER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RIV','','','',''
insert into Cln_Lookups select 1789, 'US','STREETABBREV','RIVR','RIVER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RIV','','','',''
insert into Cln_Lookups select 1790, 'US','STREETABBREV','RVR','RIVER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RIV','','','',''
insert into Cln_Lookups select 1791, 'US','STREETABBREV','RD','ROAD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RD','','','',''
insert into Cln_Lookups select 1792, 'US','STREETABBREV','ROAD','ROAD','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RD','','','',''
insert into Cln_Lookups select 1793, 'US','STREETABBREV','RDS','ROADS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDS','','','',''
insert into Cln_Lookups select 1794, 'US','STREETABBREV','ROADS','ROADS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RDS','','','',''
insert into Cln_Lookups select 1795, 'US','STREETABBREV','ROUTE','ROUTE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RTE','','','',''
insert into Cln_Lookups select 1796, 'US','STREETABBREV','ROW','ROW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ROW','','','',''
insert into Cln_Lookups select 1797, 'US','STREETABBREV','RUE','RUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RUE','','','',''
insert into Cln_Lookups select 1798, 'US','STREETABBREV','RUN','RUN','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RUN','','','',''
insert into Cln_Lookups select 1799, 'US','STREETABBREV','SHL','SHOAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHL','','','',''
insert into Cln_Lookups select 1800, 'US','STREETABBREV','SHOAL','SHOAL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHL','','','',''
insert into Cln_Lookups select 1801, 'US','STREETABBREV','SHLS','SHOALS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHLS','','','',''
insert into Cln_Lookups select 1802, 'US','STREETABBREV','SHOALS','SHOALS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHLS','','','',''
insert into Cln_Lookups select 1803, 'US','STREETABBREV','SHOAR','SHORE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHR','','','',''
insert into Cln_Lookups select 1804, 'US','STREETABBREV','SHORE','SHORE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHR','','','',''
insert into Cln_Lookups select 1805, 'US','STREETABBREV','SHR','SHORE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHR','','','',''
insert into Cln_Lookups select 1806, 'US','STREETABBREV','SHOARS','SHORES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHRS','','','',''
insert into Cln_Lookups select 1807, 'US','STREETABBREV','SHORES','SHORES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHRS','','','',''
insert into Cln_Lookups select 1808, 'US','STREETABBREV','SHRS','SHORES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SHRS','','','',''
insert into Cln_Lookups select 1809, 'US','STREETABBREV','SKYWAY','SKYWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SKWY','','','',''
insert into Cln_Lookups select 1810, 'US','STREETABBREV','SPG','SPRING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPG','','','',''
insert into Cln_Lookups select 1811, 'US','STREETABBREV','SPNG','SPRING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPG','','','',''
insert into Cln_Lookups select 1812, 'US','STREETABBREV','SPRING','SPRING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPG','','','',''
insert into Cln_Lookups select 1813, 'US','STREETABBREV','SPRNG','SPRING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPG','','','',''
insert into Cln_Lookups select 1814, 'US','STREETABBREV','SPGS','SPRINGS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPGS','','','',''
insert into Cln_Lookups select 1815, 'US','STREETABBREV','SPNGS','SPRINGS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPGS','','','',''
insert into Cln_Lookups select 1816, 'US','STREETABBREV','SPRINGS','SPRINGS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPGS','','','',''
insert into Cln_Lookups select 1817, 'US','STREETABBREV','SPRNGS','SPRINGS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPGS','','','',''
insert into Cln_Lookups select 1818, 'US','STREETABBREV','SPUR','SPUR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPUR','','','',''
insert into Cln_Lookups select 1819, 'US','STREETABBREV','SPURS','SPURS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPUR','','','',''
insert into Cln_Lookups select 1820, 'US','STREETABBREV','SQ','SQUARE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQ','','','',''
insert into Cln_Lookups select 1821, 'US','STREETABBREV','SQR','SQUARE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQ','','','',''
insert into Cln_Lookups select 1822, 'US','STREETABBREV','SQRE','SQUARE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQ','','','',''
insert into Cln_Lookups select 1823, 'US','STREETABBREV','SQU','SQUARE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQ','','','',''
insert into Cln_Lookups select 1824, 'US','STREETABBREV','SQUARE','SQUARE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQ','','','',''
insert into Cln_Lookups select 1825, 'US','STREETABBREV','SQRS','SQUARES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQS','','','',''
insert into Cln_Lookups select 1826, 'US','STREETABBREV','SQUARES','SQUARES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SQS','','','',''
insert into Cln_Lookups select 1827, 'US','STREETABBREV','STA','STATION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STA','','','',''
insert into Cln_Lookups select 1828, 'US','STREETABBREV','STATION','STATION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STA','','','',''
insert into Cln_Lookups select 1829, 'US','STREETABBREV','STATN','STATION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STA','','','',''
insert into Cln_Lookups select 1830, 'US','STREETABBREV','STN','STATION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STA','','','',''
insert into Cln_Lookups select 1831, 'US','STREETABBREV','STRA','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1832, 'US','STREETABBREV','STRAV','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1833, 'US','STREETABBREV','STRAVE','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1834, 'US','STREETABBREV','STRAVEN','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1835, 'US','STREETABBREV','STRAVENUE','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1836, 'US','STREETABBREV','STRAVN','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1837, 'US','STREETABBREV','STRVN','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1838, 'US','STREETABBREV','STRVNUE','STRAVENUE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRA','','','',''
insert into Cln_Lookups select 1839, 'US','STREETABBREV','STREAM','STREAM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRM','','','',''
insert into Cln_Lookups select 1840, 'US','STREETABBREV','STREME','STREAM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRM','','','',''
insert into Cln_Lookups select 1841, 'US','STREETABBREV','STRM','STREAM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STRM','','','',''
insert into Cln_Lookups select 1842, 'US','STREETABBREV','ST','STREET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ST','','','',''
insert into Cln_Lookups select 1843, 'US','STREETABBREV','STR','STREET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ST','','','',''
insert into Cln_Lookups select 1844, 'US','STREETABBREV','STREET','STREET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ST','','','',''
insert into Cln_Lookups select 1845, 'US','STREETABBREV','STRT','STREET','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'ST','','','',''
insert into Cln_Lookups select 1846, 'US','STREETABBREV','STREETS','STREETS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STS','','','',''
insert into Cln_Lookups select 1847, 'US','STREETABBREV','SMT','SUMMIT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SMT','','','',''
insert into Cln_Lookups select 1848, 'US','STREETABBREV','SUMIT','SUMMIT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SMT','','','',''
insert into Cln_Lookups select 1849, 'US','STREETABBREV','SUMITT','SUMMIT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SMT','','','',''
insert into Cln_Lookups select 1850, 'US','STREETABBREV','SUMMIT','SUMMIT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SMT','','','',''
insert into Cln_Lookups select 1851, 'US','STREETABBREV','TER','TERRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TER','','','',''
insert into Cln_Lookups select 1852, 'US','STREETABBREV','TERR','TERRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TER','','','',''
insert into Cln_Lookups select 1853, 'US','STREETABBREV','TERRACE','TERRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TER','','','',''
insert into Cln_Lookups select 1854, 'US','STREETABBREV','THROUGHWAY','THROUGHWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRWY','','','',''
insert into Cln_Lookups select 1855, 'US','STREETABBREV','TRACE','TRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRCE','','','',''
insert into Cln_Lookups select 1856, 'US','STREETABBREV','TRACES','TRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRCE','','','',''
insert into Cln_Lookups select 1857, 'US','STREETABBREV','TRCE','TRACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRCE','','','',''
insert into Cln_Lookups select 1858, 'US','STREETABBREV','TRACK','TRACK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRAK','','','',''
insert into Cln_Lookups select 1859, 'US','STREETABBREV','TRACKS','TRACK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRAK','','','',''
insert into Cln_Lookups select 1860, 'US','STREETABBREV','TRAK','TRACK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRAK','','','',''
insert into Cln_Lookups select 1861, 'US','STREETABBREV','TRK','TRACK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRAK','','','',''
insert into Cln_Lookups select 1862, 'US','STREETABBREV','TRKS','TRACK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRAK','','','',''
insert into Cln_Lookups select 1863, 'US','STREETABBREV','TRAFFICWAY','TRAFFICWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRFY','','','',''
insert into Cln_Lookups select 1864, 'US','STREETABBREV','TRFY','TRAFFICWAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRFY','','','',''
insert into Cln_Lookups select 1865, 'US','STREETABBREV','TR','TRAIL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRL','','','',''
insert into Cln_Lookups select 1866, 'US','STREETABBREV','TRAIL','TRAIL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRL','','','',''
insert into Cln_Lookups select 1867, 'US','STREETABBREV','TRAILS','TRAIL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRL','','','',''
insert into Cln_Lookups select 1868, 'US','STREETABBREV','TRL','TRAIL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRL','','','',''
insert into Cln_Lookups select 1869, 'US','STREETABBREV','TRLS','TRAIL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRL','','','',''
insert into Cln_Lookups select 1870, 'US','STREETABBREV','TUNEL','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1871, 'US','STREETABBREV','TUNL','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1872, 'US','STREETABBREV','TUNLS','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1873, 'US','STREETABBREV','TUNNEL','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1874, 'US','STREETABBREV','TUNNELS','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1875, 'US','STREETABBREV','TUNNL','TUNNEL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TUNL','','','',''
insert into Cln_Lookups select 1876, 'US','STREETABBREV','TPK','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1877, 'US','STREETABBREV','TPKE','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1878, 'US','STREETABBREV','TRNPK','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1879, 'US','STREETABBREV','TRPK','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1880, 'US','STREETABBREV','TURNPIKE','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1881, 'US','STREETABBREV','TURNPK','TURNPIKE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TPKE','','','',''
insert into Cln_Lookups select 1882, 'US','STREETABBREV','UNDERPASS','UNDERPASS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UPAS','','','',''
insert into Cln_Lookups select 1883, 'US','STREETABBREV','UN','UNION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UN','','','',''
insert into Cln_Lookups select 1884, 'US','STREETABBREV','UNION','UNION','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UN','','','',''
insert into Cln_Lookups select 1885, 'US','STREETABBREV','UNIONS','UNIONS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UNS','','','',''
insert into Cln_Lookups select 1886, 'US','STREETABBREV','VALLEY','VALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLY','','','',''
insert into Cln_Lookups select 1887, 'US','STREETABBREV','VALLY','VALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLY','','','',''
insert into Cln_Lookups select 1888, 'US','STREETABBREV','VLLY','VALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLY','','','',''
insert into Cln_Lookups select 1889, 'US','STREETABBREV','VLY','VALLEY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLY','','','',''
insert into Cln_Lookups select 1890, 'US','STREETABBREV','VALLEYS','VALLEYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLYS','','','',''
insert into Cln_Lookups select 1891, 'US','STREETABBREV','VLYS','VALLEYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLYS','','','',''
insert into Cln_Lookups select 1892, 'US','STREETABBREV','VDCT','VIADUCT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIA','','','',''
insert into Cln_Lookups select 1893, 'US','STREETABBREV','VIA','VIADUCT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIA','','','',''
insert into Cln_Lookups select 1894, 'US','STREETABBREV','VIADCT','VIADUCT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIA','','','',''
insert into Cln_Lookups select 1895, 'US','STREETABBREV','VIADUCT','VIADUCT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIA','','','',''
insert into Cln_Lookups select 1896, 'US','STREETABBREV','VIEW','VIEW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VW','','','',''
insert into Cln_Lookups select 1897, 'US','STREETABBREV','VW','VIEW','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VW','','','',''
insert into Cln_Lookups select 1898, 'US','STREETABBREV','VIEWS','VIEWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VWS','','','',''
insert into Cln_Lookups select 1899, 'US','STREETABBREV','VWS','VIEWS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VWS','','','',''
insert into Cln_Lookups select 1900, 'US','STREETABBREV','VILL','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1901, 'US','STREETABBREV','VILLAG','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1902, 'US','STREETABBREV','VILLAGE','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1903, 'US','STREETABBREV','VILLG','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1904, 'US','STREETABBREV','VILLIAGE','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1905, 'US','STREETABBREV','VLG','VILLAGE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLG','','','',''
insert into Cln_Lookups select 1906, 'US','STREETABBREV','VILLAGES','VILLAGES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLGS','','','',''
insert into Cln_Lookups select 1907, 'US','STREETABBREV','VLGS','VILLAGES','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VLGS','','','',''
insert into Cln_Lookups select 1908, 'US','STREETABBREV','VILLE','VILLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VL','','','',''
insert into Cln_Lookups select 1909, 'US','STREETABBREV','VL','VILLE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VL','','','',''
insert into Cln_Lookups select 1910, 'US','STREETABBREV','VIS','VISTA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIS','','','',''
insert into Cln_Lookups select 1911, 'US','STREETABBREV','VIST','VISTA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIS','','','',''
insert into Cln_Lookups select 1912, 'US','STREETABBREV','VISTA','VISTA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIS','','','',''
insert into Cln_Lookups select 1913, 'US','STREETABBREV','VST','VISTA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIS','','','',''
insert into Cln_Lookups select 1914, 'US','STREETABBREV','VSTA','VISTA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'VIS','','','',''
insert into Cln_Lookups select 1915, 'US','STREETABBREV','WALK','WALK','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WALK','','','',''
insert into Cln_Lookups select 1916, 'US','STREETABBREV','WALKS','WALKS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WALK','','','',''
insert into Cln_Lookups select 1917, 'US','STREETABBREV','WALL','WALL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WALL','','','',''
insert into Cln_Lookups select 1918, 'US','STREETABBREV','WAY','WAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WAY','','','',''
insert into Cln_Lookups select 1919, 'US','STREETABBREV','WY','WAY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WAY','','','',''
insert into Cln_Lookups select 1920, 'US','STREETABBREV','WAYS','WAYS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WAYS','','','',''
insert into Cln_Lookups select 1921, 'US','STREETABBREV','WELL','WELL','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WL','','','',''
insert into Cln_Lookups select 1922, 'US','STREETABBREV','WELLS','WELLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WLS','','','',''
insert into Cln_Lookups select 1923, 'US','STREETABBREV','WLS','WELLS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'WLS','','','',''
insert into Cln_Lookups select 1924, 'US','SUITEABBREV','APARTMENT','APARTMENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'APT','','','',''
insert into Cln_Lookups select 1925, 'US','SUITEABBREV','BASEMENT','BASEMENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BSMT','','','',''
insert into Cln_Lookups select 1926, 'US','SUITEABBREV','BUILDING','BUILDING','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'BLDG','','','',''
insert into Cln_Lookups select 1927, 'US','SUITEABBREV','DEPARTMENT','DEPARTMENT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'DEPT','','','',''
insert into Cln_Lookups select 1928, 'US','SUITEABBREV','FLOOR','FLOOR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FL','','','',''
insert into Cln_Lookups select 1929, 'US','SUITEABBREV','FRONT','FRONT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'FRNT','','','',''
insert into Cln_Lookups select 1930, 'US','SUITEABBREV','HANGAR','HANGAR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'HNGR','','','',''
insert into Cln_Lookups select 1931, 'US','SUITEABBREV','LOBBY','LOBBY','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LBBY','','','',''
insert into Cln_Lookups select 1932, 'US','SUITEABBREV','LOT','LOT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LOT','','','',''
insert into Cln_Lookups select 1933, 'US','SUITEABBREV','LOWER','LOWER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'LOWR','','','',''
insert into Cln_Lookups select 1934, 'US','SUITEABBREV','OFFICE','OFFICE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'OFC','','','',''
insert into Cln_Lookups select 1935, 'US','SUITEABBREV','PENTHOUSE','PENTHOUSE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PH','','','',''
insert into Cln_Lookups select 1936, 'US','SUITEABBREV','PIER','PIER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'PIER','','','',''
insert into Cln_Lookups select 1937, 'US','SUITEABBREV','REAR','REAR','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'REAR','','','',''
insert into Cln_Lookups select 1938, 'US','SUITEABBREV','ROOM','ROOM','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'RM','','','',''
insert into Cln_Lookups select 1939, 'US','SUITEABBREV','SIDE','SIDE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SIDE','','','',''
insert into Cln_Lookups select 1940, 'US','SUITEABBREV','SLIP','SLIP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SLIP','','','',''
insert into Cln_Lookups select 1941, 'US','SUITEABBREV','SPACE','SPACE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'SPC','','','',''
insert into Cln_Lookups select 1942, 'US','SUITEABBREV','STOP','STOP','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STOP','','','',''
insert into Cln_Lookups select 1943, 'US','SUITEABBREV','SUITE','SUITE','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'STE','','','',''
insert into Cln_Lookups select 1944, 'US','SUITEABBREV','TRAILER','TRAILER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'TRLR','','','',''
insert into Cln_Lookups select 1945, 'US','SUITEABBREV','UNIT','UNIT','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UNIT','','','',''
insert into Cln_Lookups select 1946, 'US','SUITEABBREV','UPPER','UPPER','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'UPPR','','','',''
insert into Cln_Lookups select 1947, '','TIMEZONE','0','None - Military APO/FPO','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1948, '','TIMEZONE','4','Atlantic Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1949, '','TIMEZONE','5','Eastern Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1950, '','TIMEZONE','6','Central Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1951, '','TIMEZONE','7','Mountain Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1952, '','TIMEZONE','8','Pacific Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1953, '','TIMEZONE','9','Alaska Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1954, '','TIMEZONE','10','Hawaii Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1955, '','TIMEZONE','11','Samoa Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1956, '','TIMEZONE','13','Marshall Island Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1957, '','TIMEZONE','14','Guam Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1958, '','TIMEZONE','15','Palau Time','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1959, '','ZIPTYPE','P','A ZIP Code used only for PO Boxes','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1960, '','ZIPTYPE','U','Unique: A ZIP Code assigned to an organization or government institution such as the IRS','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 1961, '','ZIPTYPE','M','Military: A ZIP Code assigned to an APO/FPO','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 15 2000  5:56PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2001, 'AF','COUNTRY','AF','Afghanistan','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  1:02PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+93','','','',''
insert into Cln_Lookups select 2002, 'AQ','COUNTRY','AQ','Antarctica','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2003, 'AZ','COUNTRY','AZ','Azerbaijan','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2004, 'BV','COUNTRY','BV','Bouvet Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2005, 'IO','COUNTRY','IO','British Indian Ocean Territory','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2006, 'CX','COUNTRY','CX','Christmas Island','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+672','','','',''
insert into Cln_Lookups select 2007, 'CC','COUNTRY','CC','Cocos Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+672','','','',''
insert into Cln_Lookups select 2008, 'KM','COUNTRY','KM','Comoros','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+269','','','',''
insert into Cln_Lookups select 2009, 'CD','COUNTRY','CD','Congo, The Democratic Republic of','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2010, 'CU','COUNTRY','CU','Cuba','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+53','','','',''
insert into Cln_Lookups select 2011, 'TP','COUNTRY','TP','East Timor','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+62','','','',''
insert into Cln_Lookups select 2012, 'FK','COUNTRY','FK','Falkland Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+500','','','',''
insert into Cln_Lookups select 2013, 'FX','COUNTRY','FX','France, Metropolitan','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2014, 'TF','COUNTRY','TF','French Southern Territories','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2015, 'HM','COUNTRY','HM','Heard and Mc Donald Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2016, 'IR','COUNTRY','IR','Iran','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+98','','','',''
insert into Cln_Lookups select 2017, 'IQ','COUNTRY','IQ','Iraq','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+964','','','',''
insert into Cln_Lookups select 2018, 'LY','COUNTRY','LY','Libya','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+21','','','',''
insert into Cln_Lookups select 2019, 'YT','COUNTRY','YT','Mayotte','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+269','','','',''
insert into Cln_Lookups select 2020, 'MN','COUNTRY','MN','Mongolia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+976','','','',''
insert into Cln_Lookups select 2021, 'NR','COUNTRY','NR','Nauru','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+674','','','',''
insert into Cln_Lookups select 2022, 'NU','COUNTRY','NU','Niue','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+683','','','',''
insert into Cln_Lookups select 2023, 'KP','COUNTRY','KP','North Korea','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+850','','','',''
insert into Cln_Lookups select 2024, 'PS','COUNTRY','PS','Palestinian Territory, Occupied','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2025, 'PN','COUNTRY','PN','Pitcairn','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2026, 'SM','COUNTRY','SM','San Marino','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+378','','','',''
insert into Cln_Lookups select 2027, 'SO','COUNTRY','SO','Somalia','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+252','','','',''
insert into Cln_Lookups select 2028, 'GS','COUNTRY','GS','South Georgia and the South Sandwich Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2029, 'SH','COUNTRY','SH','St. Helena and Ascension Island','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+247','','','',''
insert into Cln_Lookups select 2030, 'PM','COUNTRY','PM','St. Pierre and Miquelon','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+508','','','',''
insert into Cln_Lookups select 2031, 'SJ','COUNTRY','SJ','Svalbard and Jan Mayen Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+47','','','',''
insert into Cln_Lookups select 2032, 'TK','COUNTRY','TK','Tokelau','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+690','','','',''
insert into Cln_Lookups select 2033, 'UM','COUNTRY','UM','United States Minor Outlying Islands','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2034, 'VA','COUNTRY','VA','Vatican City','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+39','','','',''
insert into Cln_Lookups select 2035, 'EH','COUNTRY','EH','Western Sahara','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 19 2000  2:12PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'+21','','','',''
insert into Cln_Lookups select 2101, '','EMAILSTATUS','E','Ping Test Network Error - Please Retry','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 20 2000  1:17PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2102, '','EMAILSTATUS','C','Invalid Character in Domain Name','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Dec 21 2000 12:22PM','CLNADDR','Jan 15 2001  6:13PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2201, '','ADDRSTATUS','G0','No components validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2202, '','ADDRSTATUS','G1','Country validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2203, '','ADDRSTATUS','G2','City, Country validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2204, '','ADDRSTATUS','G3','City, Postcode, Country validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2205, '','ADDRSTATUS','G4','Street, City, Postcode, Country validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2206, '','ADDRSTATUS','G5','Premise, Street, City, Postcode, Country validated','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Nov 20 2002  9:34PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2301, '','ADDRERROR','F','DPV Offline - Artificially created address','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','DPV processing was terminated due to the detection of what is determined to be an artificially created address. No address beyond this point has been DPV validated. In accordance with the License Agreement between USPS and Melissa Data, DPV shall be used to validate legitimately obtained addresses only, and shall not be used for the purpose of artificially creating address lists. The written Agreement between Melissa Data and you, its customer shall also include this same restriction against using DPV to artificially create address lists. Continuing use of DPV requires compliance with all terms of the License Agreement. If you believe this address was identified in error, please contact Melissa Data.','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2302, '','ADDRERROR','W','Early Warning System - included in next data update','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','This address has been identified in the Early Warning System (EWS) data file, and should be included in the next national database update.','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2303, '','ADDRSTATUS','V','Street number validated to DPV level','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2304, '','ADDRSTATUS','6','The address was fully coded','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2305, '','ADDRSTATUS','SM','Suite number is required for the address','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','A suite number is required for the given street address but is missing from the submitted record.','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2306, '','ADDRSTATUS','SR','Suite number not required or out of range','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','A suite number is present on the submitted record but is either not required or is out of range for the given street address.','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2307, '','ADDRSTATUS','SV','The suite field was verified','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2308, '','ADDRSTATUS','SX','The suite field was not coded','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2309, '','DPVSTATUS','AA','Input Address Matched to the ZIP+4 file','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2310, '','DPVSTATUS','A1','Input Address Not Matched to the ZIP+4 file','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2311, '','DPVSTATUS','BB','Input Address Matched to DPV (all components)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2312, '','DPVSTATUS','CC','Input Address Primary Number Matched to DPV but Secondary Number not Matched (present but invalid)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Suite/Apt Invalid','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2313, '','DPVSTATUS','N1','Input Address Primary Number Matched to DPV but Highrise Address Missing Secondary Number','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Suite/Apt Missing','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2314, '','DPVSTATUS','M1','Input Address Primary Number Missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Street Number Missing','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2315, '','DPVSTATUS','M3','Input Address Primary Number Invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Street Number Invalid','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2316, '','DPVSTATUS','P1','Input Address Missing PO, RR, or HC Box number','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Missing PO, RR, or HC Box number','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2317, '','DPVSTATUS','RR','Input Address Matched to CMRA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2318, '','DPVSTATUS','R1','Input Address Matched to CMRA but Secondary Number not Present','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Suite/Apt Missing','','Sep  9 2003  4:36PM','CLNDEMO','May 25 2005  6:18PM','CLNADDR',3,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2401, '','ADDRSTATUS','ADV','Data correct on input (validated)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address was correct','AD_AST_ADDRESS_CORRECT','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2402, '','ADDRSTATUS','ADC','Data corrected by AddressDoctor','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address could be corrected automatically','AD_AST_ADDRESS_CORRECTED','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,1,'','','','',''
insert into Cln_Lookups select 2403, '','ADDRSTATUS','ADP3','Data cannot be corrected, but very likely to be deliverable','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address needs to be corrected, but could not be determined automatically. There is a high likelihood that this address is deliverable','AD_AST_ADDRESS_NEEDS_CORRECTION_DELIVERABILITY_HIGH','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2404, '','ADDRSTATUS','ADP2','Data cannot be corrected, but fair chance that the address is deliverable','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address needs to be corrected, but could not be determined automatically. There is a fair likelihood that this address is deliverable','AD_AST_ADDRESS_NEEDS_CORRECTION_DELIVERABILITY_FAIR','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2405, '','ADDRSTATUS','ADP1','Data cannot be corrected and unlikely to be deliverable','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address needs to be corrected, but could not be determined automatically. There is a small likelihood that this address is deliverable','AD_AST_ADDRESS_NEEDS_CORRECTION_DELIVERABILITY_SMALL','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2406, '','ADDRSTATUS','ADN4','Validation method not yet called (after parsing operation)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address was not validated yet (the validate method has not been called yet)','AD_AST_NO_VALIDATE_CALLED_YET','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2407, '','ADDRSTATUS','ADN3','No validation performed because country not unlocked','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address could not be checked, because country is not unlocked','AD_AST_COUNTRY_NOT_UNLOCKED','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2408, '','ADDRSTATUS','ADN2','No validation performed because reference database not found','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address could not be checked, because no valid country database could not be found.  Either the database is corrupt or out of date, or the path for the database was wrong','AD_AST_NO_VALID_COUNTRY_DATABASE_FOUND','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2409, '','ADDRSTATUS','ADN1','No validation performed because country not recognized','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Address could not be checked, because no country could be recognized','AD_AST_COUNTRY_NOT_RECOGNIZED','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2410, '','ADDRSTATUS','ADN5','Insufficient information to generate suggestions','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Information supplied was not insufficient for quickadressing','AD_AST_INSUFFICIENT_INFORMATION','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2411, '','ADDRSTATUS','ADQ3','Suggestions are available','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','One or several suggestions could be found for quickadressing','AD_AST_SUGGESTIONS','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2412, '','ADDRSTATUS','ADQ2','Suggested address is not complete (enter more information)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Suggestions for quickadressing is incomplete','AD_AST_SUGGESTIONS_INCOMPLETE','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2413, '','ADDRSTATUS','ADQ1','No suggestions are available','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','No suggestions available for quickadressing','AD_AST_NO_SUGGESTIONS','Apr 27 2004  4:16PM','CLNADDR','May 13 2004 12:36PM','CLNADDR',2,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2501, 'CA','STATE','NL','Newfoundland and Labrador','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Jul 27 2004  4:34PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2502, 'CA','STATE','NU','Nunavut','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','Jul 27 2004  4:34PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',4,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2601, '','ADDRSTATUS','AD0','Combination of properties assigned is plausible','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2602, '','ADDRSTATUS','AD1','Currently not supported','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2603, '','ADDRSTATUS','AD4','Country ISO code missing or invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2604, '','ADDRSTATUS','AD8','Province missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2605, '','ADDRSTATUS','AD16','Street missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2606, '','ADDRSTATUS','AD32','Locality missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2607, '','ADDRSTATUS','AD64','Post code missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2608, '','ADDRSTATUS','AD204','Post code / Locality / Province missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2609, '','ADDRSTATUS','AD96','Post code / Locality missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2610, '','ADDRSTATUS','AD72','Post code / Province missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2611, '','ADDRSTATUS','AD24','Street / Province missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2612, '','ADDRSTATUS','AD48','Street / Locality missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2613, '','ADDRSTATUS','AD40','Locality / Province missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2614, '','ADDRSTATUS','AD128','Post code too long (at least by two chars)','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2615, '','ADDRSTATUS','AD256','Post code is not a number','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2616, '','ADDRSTATUS','AD512','Post code supplied, but not needed for this country','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2617, '','ADDRSTATUS','AD1024','Post office box supplied although it was claimed to be a street','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2618, '','ADDRSTATUS','AD2048','Province name changed, e.g. California to CA','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2619, '','ADDRSTATUS','AD4096','Value not allowed for this property','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2620, '','ADDRSTATUS','AD8192','A house number is not needed for this address','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2621, '','DPVSTATUS','P3','Input Address Postal or Rural Route Primary number invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Postal or Rural Route Primary number invalid','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2622, '','ADDRERROR','A1','Address Does Not Match to ZIP+4 file','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Not Matched to the ZIP+4 file','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2623, '','ADDRERROR','CC','Suite/Apt Invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Primary Number Matched to DPV but Secondary Number not Matched (present but invalid)','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2624, '','ADDRERROR','N1','Suite/Apt Missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Primary Number Matched to DPV but Highrise Address Missing Secondary Number','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2625, '','ADDRERROR','M1','Street Number Missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Primary Number Missing','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2626, '','ADDRERROR','M3','Street Number Invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Primary Number Invalid','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2627, '','ADDRERROR','P1','Missing PO, RR, or HC Box number','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Missing PO, RR, or HC Box number','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2628, '','ADDRERROR','P3','Postal or Rural Route Primary number invalid','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Postal or Rural Route Primary number invalid','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2629, '','ADDRERROR','R1','Suite/Apt Missing','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','Input Address Matched to CMRA but Secondary Number not Present','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2630, '','AUTOMATION','Y','Carrier route sortation rates apply for this ZIP Code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''
insert into Cln_Lookups select 2631, '','AUTOMATION','N','Carrier route sortation rates DO NOT apply for this ZIP Code','',0,'Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','Jan  1 1900 12:00AM','','','','May 25 2005  6:18PM','CLNADDR','May 25 2005  6:18PM','CLNADDR',1,0,0,0,0,0,'','','','',''

go

/******************************************************************************************
 *  Procedure Name  :   Verify_Address_GENERIC
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns corrected address information.
 *					    Simplified to use a subset of all possible parameters that Verify
 *					    uses
 ******************************************************************************************/
create PROCEDURE [dbo].[Verify_GENERIC]
	@SettingsGroup [nvarchar](50),
	@Address_Name [nvarchar](300) output, 
	@Company_Name [nvarchar](256) output,
	@Attention [nvarchar](256) OUTPUT,
	@Address [nvarchar](256) OUTPUT,
	@Suite [nvarchar](256) output,
	@Address_Line_1 [nvarchar](256) output,
	@Address_Line_2 [nvarchar](256) output,
	@Address_Line_3 [nvarchar](256) output,
	@Address_Line_4 [nvarchar](256) output,
	@Address_Line_7 [nvarchar](256) output,
	@Address_Line_8 [nvarchar](256) output,
	@City [nvarchar](100) output,
	@City_Abbreviation [nvarchar](100) output,
	@State [nvarchar](100) output,
	@Postal_Code [nvarchar](50) output,
	@Postal_Code_Extended [nvarchar](50) output,
	@Last_Line [nvarchar](256) output,
	@Country_Code [nvarchar](30) output,
	@Country_Name [nvarchar](100) output,
	@Province [nvarchar](100) output,
	@Delivery_Point [nvarchar](2) output,
	@Check_Digit [nvarchar](1) output,
	@Parsed_Street_Suffix [nvarchar](40) output,
	@Parsed_Unit_Type [nvarchar](40) output,
	@Suggestion_List [nvarchar](4000) output,
	@County_Code [nvarchar](20) output,
	@County_Name [nvarchar](100) output,
	@Error_Code [nvarchar](20) output,
	@Error_String [nvarchar](4000) output,
	@Status_Code [nvarchar](20) output,
	@DPV_Status [nvarchar](20) output,
	@fn_Address_Lines int = 4,
    @fb_generic_address_name bit = 0,
    @fb_generic_company bit = 0,
    @fb_address_suite_same_line bit = 0,
    @fn_Error_Suggest_Count int = 0,
    @fb_Verbose_Suggest_list bit = 0,
    @fb_upper_case_results bit = 0

as
-- Debug
--Declare @Response nvarchar(4000)
--exec  Verify_Address_AJAX '','10 Fairway Dr Ste 133','','','','Deerfield Beach','FL', '33441','','','','Computer Ways, Inc.','', @Response output
--Select @Response
--Declare	@SettingsGroup nvarchar(50),@Address_1 nvarchar(256),@Address_2 nvarchar(256) ,@Address_3 nvarchar(256) ,@Address_4 nvarchar(256) ,@City nvarchar(100) ,@State nvarchar(100) ,@Postal_Code nvarchar(50) ,@County_Code nvarchar(20) ,@Country_Code nvarchar(30) ,@fv_address_type nvarchar(500) ,@Company_Name nvarchar(256) ,@fv_object_name nvarchar(500) ,@fv_response nvarchar(4000)                 
--select @Address_1 = '', @Address_2 = '10 Fairway Dr Ste 133',@Address_3 = '',@Address_4 = '',@City = 'Deerfield Beach',@State = 'FL',@Postal_Code  = '33441',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = 'Computer Ways, Inc.',@fv_object_name = ''
--select @Address_1 = '6530 W Rogers', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'bocaraton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '132 Leopold Strasse', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'munich',@State = '',@Postal_Code  = '',@County_Code = '',@Country_Code = 'DEU',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '66666530 W Rogers', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'boca raton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '6530 W Rogers Ste 31', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'boca raton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--End Debug
------------------------------------------------
-- Some global settings
------------------------------------------------
Declare @gn_Max_State_Length int -- 100?
Select @gn_Max_State_Length = cast(dbo.Get_Setting(@SettingsGroup,'MaxProvinceLength') as int)

Declare @gn_Max_Address_Length int -- 256??
Select @gn_Max_Address_Length = cast(dbo.Get_Setting(@SettingsGroup,'MaxAddressLineLength') as int)
--
Declare @gn_Max_City_Length int -- 100?
Select @gn_Max_City_Length = cast(dbo.Get_Setting(@SettingsGroup,'MaxCityLength') as int)
--
Declare @BlankLine nvarchar(2)
set @BlankLine = ' '
-- What about the "l_" variables?
-------------------------------------------------------------------
-- Declare other variables needed to call the main Verify routine.
-------------------------------------------------------------------
Declare
--@Address_Name nvarchar(300), /* IN/OUT - Full Name - will be parsed if specified */
--@Attention nvarchar(256), /* IN/OUT */
--@Address nvarchar(256) ,  /* IN/OUT - House float and Street Address */
--@Suite nvarchar(256) ,  /* IN/OUT - Suite / Apartment float */
@Private_Mailbox nvarchar(100) ,  /* Private Mail Box Facility */
@Address_Line_5 nvarchar(256) ,@Address_Line_6 nvarchar(256) ,
--@Address_Line_7 nvarchar(256) ,
--@Address_Line_8 nvarchar(256) ,
--@City_Abbreviation nvarchar(100) ,
--@Postal_Code_Extended nvarchar(50) ,   /* IN/OUT - ie ZIP+4 */
--@Last_Line nvarchar(256) ,  /* Last Address Line: City@ State Zip-Plus4 (US Only) , */
--@Country_Name nvarchar(100) ,  /* IN/OUT */
@Urbanization nvarchar(256) ,  /* IN/OUT - Puerto Rico Addresses Only */
--@Province nvarchar(100) ,  /* IN/OUT - International Addresses */
@Carrier_Route nvarchar(20) ,@Delivery_Point_Check_Digit nvarchar(10) ,
--@Delivery_Point nvarchar(2) ,
--@Check_Digit nvarchar(1) ,
@Parsed_Address_Range nvarchar(60) ,@Parsed_Address_float nvarchar(60) ,@Parsed_Pre_Direction nvarchar(40) ,
@Parsed_Street_Name nvarchar(100) ,
--@Parsed_Street_Suffix nvarchar(40) ,
@Parse_Post_Direction nvarchar(40) ,
--@Parsed_Unit_Type  nvarchar(40) ,
@Parsed_Unit_float  nvarchar(40) ,
@Parsed_Private_Mailbox_Type  nvarchar(40) ,  /* Private Mail Box Type (ie PMB) , */
@Parsed_Private_Mailbox_float nvarchar(40) ,  /* Private Mail Box float (ie 124B) , */
--@Suggestion_List nvarchar(4000) ,
--@County_Name nvarchar(100) ,
@Timezone_Code nvarchar(5) ,@Timezone_String nvarchar(100) ,
--@Error_Code nvarchar(20) ,    /* Primary field to check for an address error (View: CLN_ADDRESS_ERRORS_V) , */
--@Error_String nvarchar(4000) ,
--@Status_Code nvarchar(20) ,    /* Address Status code (View: CLN_ADDRESS_STATUS_V) , */
--@DPV_Status nvarchar(20) ,    /* Delivery Point Validation Status - AA BB RR are verified successfully */
@DPV_Error_Code nvarchar(20) ,    /* Decode of DPV_Status and Error_Code to return prominant error code */
@RBDI_Code nvarchar(20) ,    /* (R) ,esidential / (B) ,usiness Delivery Indicator (R/B) , - EXTRA DATA OPTION */
@CMRA nvarchar(1) ,     /* Commercial Mail Receiving Agency (Y/N) , */
@Address_Type_Code nvarchar(20) ,
@Address_Type_String nvarchar(100) ,
@MSA nvarchar(20) ,
@PMSA nvarchar(20) ,
@Congressional_District nvarchar(20) ,
@LACS_Code nvarchar(20) ,    /* L = Address has undergone a conversion */
@Automation_Code nvarchar(20) ,    /* Y = Carrier Route sortation rates apply for this Postal Code */
@Facility_Code nvarchar(20) ,
@Zip_Type_Code nvarchar(20) ,    /* NULL = Standard; P = PO Box Only Postal Code; U = Unique for Organization (ie IRS) ,; M = Military */
@Latitude float(24),@Longitude float(24),@Census_Tract nvarchar(10) ,@Census_Block nvarchar(10) ,
@First_Name nvarchar(100) ,   /* IN/OUT */
@Middle_Name nvarchar(100) ,   /* IN/OUT */
@Last_Name nvarchar(100) ,   /* IN/OUT */
@Name_Prefix nvarchar(50) ,   /* IN/OUT */
@Name_Suffix nvarchar(50) ,   /* IN/OUT */
@Standardized_First_Name nvarchar(100) ,
@Gender nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@First_Name_2 nvarchar(100) ,@Middle_Name_2 nvarchar(100) ,@Last_Name_2 nvarchar(100) ,@Name_Prefix_2 nvarchar(50) ,@Name_Suffix_2 nvarchar(50) ,@Standardized_First_Name_2 nvarchar(100) ,
@Gender_2 nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@Name_Parse_Status_Code nvarchar(20) ,   /* ' ' = Successful Parse; 'V' = Vulgar world found; 'X' = Unable to Parse */
@Phone_float nvarchar(30) ,   /* IN/OUT */
@Phone_float_Output_Format nvarchar(30) ,   /* Format mask to apply for output - Use # for place holder@ ie (###) ,###-#### */
@New_Phone_float nvarchar(30) ,@New_Phone_Area_Code nvarchar(15) ,
@Phone_Area_Code nvarchar(15) ,   /* IN/OUT */
@Phone_Prefix nvarchar(15) ,   /* IN/OUT */
@Phone_Suffix nvarchar(15) ,   /* IN/OUT */
@Phone_Extension nvarchar(15) ,@Phone_Distance float(24),@Phone_Check_Status_Code nvarchar(20) ,@Phone_Check_Error_Code nvarchar(20),
@AddressKey nvarchar(100),
@CountyFIPS nvarchar(100),
@CountyName nvarchar(100),
--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
@Standardized_Middle_Name nvarchar(100),
@Results nvarchar(4000),
@GenericAddressLineFormat nvarchar(100),
@CBSACode nvarchar(100),
@CBSATitle nvarchar(100),
@CBSALevel nvarchar(100),
@CBSADivisionCode nvarchar(100),
@CBSADivisionTitle nvarchar(100),
@CBSADivisionLevel nvarchar(100)
----------------------------------------------------
-- Required so that state does not come back null
----------------------------------------------------
select 
@Province  = '' /* IN/OUT - International Addresses */
------------------------------------------------------------
EXEC Verify 
@SettingsGroup,@Address_Name output,@Company_Name output,@Attention output,
@Address output, @Suite output,@Private_Mailbox output,
@Address_Line_1 output,@Address_Line_2 output,@Address_Line_3 output,@Address_Line_4 output,
@Address_Line_5 output,@Address_Line_6 output,@Address_Line_7 output,@Address_Line_8 output,
@City output,@City_Abbreviation output,@State output,@Postal_Code output,@Postal_Code_Extended output,
@Last_Line output,@Country_Code output,@Country_Name output,@Urbanization output,@Province output,
@Carrier_Route output,@Delivery_Point_Check_Digit output,@Delivery_Point output,@Check_Digit output,
@Parsed_Address_Range output,@Parsed_Address_float output,@Parsed_Pre_Direction output,@Parsed_Street_Name output,@Parsed_Street_Suffix output,@Parse_Post_Direction output,@Parsed_Unit_Type  output,@Parsed_Unit_float  output,@Parsed_Private_Mailbox_Type output,@Parsed_Private_Mailbox_float output,
@Suggestion_List output,
@County_Code output,@County_Name output,
@Timezone_Code output,@Timezone_String output,
@Error_Code output,@Error_String output,@Status_Code output,
@DPV_Status output,@DPV_Error_Code output,
@RBDI_Code output,@CMRA output, @Address_Type_Code output,@Address_Type_String output,
@MSA output,@PMSA output,@Congressional_District output,@LACS_Code output,@Automation_Code output,@Facility_Code output,@Zip_Type_Code output,
@Latitude output,@Longitude output,@Census_Tract output,@Census_Block output,
@First_Name output,@Middle_Name output,@Last_Name output,@Name_Prefix output,@Name_Suffix output,@Standardized_First_Name output,@Gender output,
@First_Name_2 output,@Middle_Name_2 output,@Last_Name_2 output,@Name_Prefix_2 output,@Name_Suffix_2 output,@Standardized_First_Name_2 output,@Gender_2 output,
@Name_Parse_Status_Code output,@Phone_float output,@Phone_float_Output_Format,
@New_Phone_float output,@New_Phone_Area_Code output,@Phone_Area_Code output,@Phone_Prefix output,@Phone_Suffix output,@Phone_Extension output,
@Phone_Distance output,@Phone_Check_Status_Code output,@Phone_Check_Error_Code output,
@AddressKey OUTPUT,
@CountyFIPS OUTPUT,
@CountyName OUTPUT,
--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
@Standardized_Middle_Name OUTPUT,
@Results OUTPUT,
@GenericAddressLineFormat OUTPUT,
@CBSACode OUTPUT,
@CBSATitle OUTPUT,
@CBSALevel OUTPUT,
@CBSADivisionCode  OUTPUT,
@CBSADivisionTitle OUTPUT,
@CBSADivisionLevel OUTPUT
set nocount off

Go
